/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class XmlBox
extends AbstractFullBox {
    String xml;
    public static final String TYPE = "xml ";

    public XmlBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    protected long getContentSize() {
        return IsoFile.utf8StringLengthInBytes(this.xml);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.xml);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long a = in.remaining();
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long b = in.remaining();
        assert ((size -= a - b) < Integer.MAX_VALUE);
        this.xml = in.readString((int)size);
    }
}

