/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.assistui.isDate;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class TrackHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tkhd";
    private long creationTime;
    private long modificationTime;
    private long trackId;
    private long duration;
    private int layer;
    private int alternateGroup;
    private float volume;
    private long[] matrix = new long[]{65536L, 0L, 0L, 0L, 65536L, 0L, 0L, 0L, 0x40000000L};
    private double width;
    private double height;

    public TrackHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
        this.setFlags(7);
    }

    @isDate
    public long getCreationTime() {
        return this.creationTime;
    }

    @isDate
    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getAlternateGroup() {
        return this.alternateGroup;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    protected long getContentSize() {
        long contentSize = 0L;
        contentSize = this.getVersion() == 1 ? (contentSize += 32L) : (contentSize += 20L);
        return contentSize += 60L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if (this.getVersion() == 1) {
            this.creationTime = in.readUInt64();
            this.modificationTime = in.readUInt64();
            this.trackId = in.readUInt32();
            in.readUInt32();
            this.duration = in.readUInt64();
        } else {
            this.creationTime = in.readUInt32();
            this.modificationTime = in.readUInt32();
            this.trackId = in.readUInt32();
            in.readUInt32();
            this.duration = in.readUInt32();
        }
        in.readUInt32();
        in.readUInt32();
        this.layer = in.readUInt16();
        this.alternateGroup = in.readUInt16();
        this.volume = in.readFixedPoint88();
        in.readUInt16();
        this.matrix = new long[9];
        for (int i = 0; i < 9; ++i) {
            this.matrix[i] = in.readUInt32();
        }
        this.width = in.readFixedPoint1616();
        this.height = in.readFixedPoint1616();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (this.getVersion() == 1) {
            isos.writeUInt64(this.creationTime);
            isos.writeUInt64(this.modificationTime);
            isos.writeUInt32(this.trackId);
            isos.writeUInt32(0L);
            isos.writeUInt64(this.duration);
        } else {
            isos.writeUInt32((int)this.creationTime);
            isos.writeUInt32((int)this.modificationTime);
            isos.writeUInt32(this.trackId);
            isos.writeUInt32(0L);
            isos.writeUInt32((int)this.duration);
        }
        isos.writeUInt32(0L);
        isos.writeUInt32(0L);
        isos.writeUInt16(this.layer);
        isos.writeUInt16(this.alternateGroup);
        isos.writeFixedPont88(this.volume);
        isos.writeUInt16(0);
        for (int i = 0; i < 9; ++i) {
            isos.writeUInt32(this.matrix[i]);
        }
        isos.writeFixedPont1616(this.width);
        isos.writeFixedPont1616(this.height);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("TrackHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("trackId=").append(this.getTrackId());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("layer=").append(this.getLayer());
        result.append(";");
        result.append("alternateGroup=").append(this.getAlternateGroup());
        result.append(";");
        result.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            result.append(";");
            result.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        result.append(";");
        result.append("width=").append(this.getWidth());
        result.append(";");
        result.append("height=").append(this.getHeight());
        result.append("]");
        return result.toString();
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public void setAlternateGroup(int alternateGroup) {
        this.alternateGroup = alternateGroup;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setMatrix(long[] matrix) {
        this.matrix = matrix;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public boolean isEnabled() {
        return (this.getFlags() & 1) > 0;
    }

    public boolean isInMovie() {
        return (this.getFlags() & 2) > 0;
    }

    public boolean isInPreview() {
        return (this.getFlags() & 4) > 0;
    }

    public boolean isInPoster() {
        return (this.getFlags() & 8) > 0;
    }
}

