/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleDependencyTypeBox
extends AbstractFullBox {
    public static final String TYPE = "sdtp";
    private List<Entry> entries = new ArrayList<Entry>();

    public SampleDependencyTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return this.entries.size();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Entry entry : this.entries) {
            os.write(entry.value);
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        for (long remainingBytes = size - 4L; remainingBytes > 0L; --remainingBytes) {
            this.entries.add(new Entry(in.readUInt8()));
        }
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleDependencyTypeBox");
        sb.append("{entries=").append(this.entries);
        sb.append('}');
        return sb.toString();
    }

    public static class Entry {
        private int value;

        public Entry(int value) {
            this.value = value;
        }

        public int getReserved() {
            return this.value >> 6 & 3;
        }

        public void setReserved(int res) {
            this.value = (res & 3) << 6 | this.value & 0x3F;
        }

        public int getSampleDependsOn() {
            return this.value >> 4 & 3;
        }

        public void setSampleDependsOn(int sdo) {
            this.value = (sdo & 3) << 4 | this.value & 0xCF;
        }

        public int getSampleIsDependentOn() {
            return this.value >> 2 & 3;
        }

        public void setSampleIsDependentOn(int sido) {
            this.value = (sido & 3) << 2 | this.value & 0xF3;
        }

        public int getSampleHasRedundancy() {
            return this.value & 3;
        }

        public void setSampleHasRedundancy(int shr) {
            this.value = shr & 3 | this.value & 0xFC;
        }

        public String toString() {
            return "Entry{reserved=" + this.getReserved() + ", sampleDependsOn=" + this.getSampleDependsOn() + ", sampleIsDependentOn=" + this.getSampleIsDependentOn() + ", sampleHasRedundancy=" + this.getSampleHasRedundancy() + '}';
        }
    }
}

