/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractFullBox
extends AbstractBox
implements FullBox {
    private int version;
    private int flags;

    protected AbstractFullBox(String type) {
        super(type);
    }

    protected AbstractFullBox(byte[] type) {
        super(type);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    protected abstract long getContentSize();

    protected long getHeaderSize() {
        return super.getHeaderSize() + 4L;
    }

    public byte[] getHeader() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IsoOutputStream ios = new IsoOutputStream(baos);
            if (this.getSize() < 0x100000000L) {
                ios.writeUInt32((int)this.getSize());
                ios.write(this.getType());
            } else {
                ios.writeUInt32(1L);
                ios.write(this.getType());
                ios.writeUInt64(this.getSize());
            }
            if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes("uuid"))) {
                ios.write(this.getUserType());
            }
            ios.writeUInt8(this.version);
            ios.writeUInt24(this.flags);
            assert ((long)baos.size() == this.getHeaderSize());
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.parseHeader(in, size);
    }

    protected void parseHeader(IsoBufferWrapper in, long size) throws IOException {
        this.version = in.readUInt8();
        this.flags = in.readUInt24();
    }
}

