/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsoFileConvenienceHelper {
    public static Box get(ContainerBox containerBox, String path) {
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return null;
        }
        ArrayList<String> partList = new ArrayList<String>(Arrays.asList(parts));
        if ("".equals(partList.get(0))) {
            partList.remove(0);
        }
        if (partList.size() > 0) {
            return IsoFileConvenienceHelper.get(containerBox.getBoxes(), partList);
        }
        return null;
    }

    private static Box get(List<Box> boxes, List<String> path) {
        String typeInPath = path.remove(0);
        for (Box box : boxes) {
            if (box instanceof ContainerBox) {
                ContainerBox boxContainer = (ContainerBox)box;
                String type = IsoFile.bytesToFourCC(boxContainer.getType());
                if (!typeInPath.equals(type)) continue;
                List<Box> children = boxContainer.getBoxes();
                if (path.size() > 0) {
                    if (children.size() <= 0) continue;
                    return IsoFileConvenienceHelper.get(children, path);
                }
                return box;
            }
            String type = IsoFile.bytesToFourCC(box.getType());
            if (path.size() != 0 || !typeInPath.equals(type)) continue;
            return box;
        }
        return null;
    }
}

