/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.DefaultHtmlSerializer;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.shindig.gadgets.parse.nekohtml.NekoSimplifiedHtmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImplementedBy(value=NekoSimplifiedHtmlParser.class)
public abstract class GadgetHtmlParser {
    public static final String PARSED_DOCUMENTS = "parsedDocuments";
    public static final String PARSED_FRAGMENTS = "parsedFragments";
    private Cache<String, Document> documentCache;
    private Cache<String, DocumentFragment> fragmentCache;
    private Provider<HtmlSerializer> serializerProvider = new DefaultSerializerProvider();
    public static final String OSML_DATA_TAG = "OSData";
    public static final String OSML_TEMPLATE_TAG = "OSTemplate";
    public static final BiMap<String, String> SCRIPT_TYPE_TO_OSML_TAG = ImmutableBiMap.of((Object)"text/os-data", (Object)"OSData", (Object)"text/os-template", (Object)"OSTemplate");

    @Inject
    public void setCacheProvider(CacheProvider cacheProvider) {
        this.documentCache = cacheProvider.createCache(PARSED_DOCUMENTS);
        this.fragmentCache = cacheProvider.createCache(PARSED_FRAGMENTS);
    }

    @Inject
    public void setSerializerProvider(Provider<HtmlSerializer> serProvider) {
        this.serializerProvider = serProvider;
    }

    protected static boolean attemptFullDocParseFirst(String content) {
        String normalized = content.substring(0, Math.min(100, content.length())).toUpperCase();
        return normalized.contains("<!DOCTYPE") || normalized.contains("<HTML");
    }

    public final Document parseDom(String source) throws GadgetException {
        Document document = null;
        String key = null;
        boolean shouldCache = this.shouldCache();
        if (shouldCache) {
            key = HashUtil.rawChecksum((byte[])source.getBytes());
            document = (Document)this.documentCache.getElement((Object)key);
        }
        if (document == null) {
            document = this.parseDomImpl(source);
            HtmlSerialization.attach(document, (HtmlSerializer)this.serializerProvider.get(), source);
            if (DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"head") == null) {
                document.getDocumentElement().insertBefore(document.createElement("head"), document.getDocumentElement().getFirstChild());
            }
            if (DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"body") == null) {
                document.getDocumentElement().appendChild(document.createElement("body"));
            }
            if (shouldCache) {
                this.documentCache.addElement((Object)key, (Object)document);
            }
        }
        if (shouldCache) {
            Document copy = (Document)document.cloneNode(true);
            HtmlSerialization.copySerializer(document, copy);
            return copy;
        }
        return document;
    }

    public final void parseFragment(String source, Node result) throws GadgetException {
        DocumentFragment cachedFragment;
        boolean shouldCache = this.shouldCache();
        String key = null;
        if (shouldCache && (cachedFragment = (DocumentFragment)this.fragmentCache.getElement((Object)(key = HashUtil.rawChecksum((byte[])source.getBytes())))) != null) {
            this.copyFragment(cachedFragment, result);
            return;
        }
        DocumentFragment fragment = this.parseFragmentImpl(source);
        if (shouldCache) {
            this.fragmentCache.addElement((Object)key, (Object)fragment);
        }
        this.copyFragment(fragment, result);
    }

    private void copyFragment(DocumentFragment source, Node dest) {
        Document destDoc = dest.getOwnerDocument();
        NodeList nodes = source.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node clone = destDoc.importNode(nodes.item(i), true);
            dest.appendChild(clone);
        }
    }

    protected boolean shouldCache() {
        return this.documentCache != null && this.documentCache.getCapacity() != 0L;
    }

    protected abstract Document parseDomImpl(String var1) throws GadgetException;

    protected abstract DocumentFragment parseFragmentImpl(String var1) throws GadgetException;

    protected void normalizeFragment(Document document, DocumentFragment fragment) {
        Node htmlNode = DomUtil.getFirstNamedChildNode((Node)fragment, (String)"HTML");
        if (htmlNode != null) {
            document.appendChild(htmlNode);
        } else {
            Node bodyNode = DomUtil.getFirstNamedChildNode((Node)fragment, (String)"body");
            Node headNode = DomUtil.getFirstNamedChildNode((Node)fragment, (String)"head");
            if (bodyNode != null || headNode != null) {
                Node root = document.appendChild(document.createElement("html"));
                if (headNode != null && bodyNode == null) {
                    fragment.removeChild(headNode);
                    root.appendChild(headNode);
                    Node body = root.appendChild(document.createElement("body"));
                    body.appendChild(fragment);
                } else {
                    root.appendChild(fragment);
                }
            } else {
                Node root = document.appendChild(document.createElement("html"));
                Node body = root.appendChild(document.createElement("body"));
                body.appendChild(fragment);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSerializerProvider
    implements Provider<HtmlSerializer> {
        private DefaultSerializerProvider() {
        }

        public HtmlSerializer get() {
            return new DefaultHtmlSerializer();
        }
    }
}

