/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.engine;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.infra.rewrite.engine.result.GenericSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.rewrite.sql.impl.DefaultSQLBuilder;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.apache.shardingsphere.sqltranslator.context.SQLTranslatorContext;
import org.apache.shardingsphere.sqltranslator.rule.SQLTranslatorRule;

public final class GenericSQLRewriteEngine {
    private final SQLTranslatorRule translatorRule;
    private final ShardingSphereDatabase database;
    private final RuleMetaData globalRuleMetaData;

    public GenericSQLRewriteResult rewrite(SQLRewriteContext sqlRewriteContext, QueryContext queryContext) {
        DatabaseType protocolType = this.database.getProtocolType();
        Map storageUnits = this.database.getResourceMetaData().getStorageUnits();
        DatabaseType storageType = storageUnits.isEmpty() ? protocolType : ((StorageUnit)storageUnits.values().iterator().next()).getStorageType();
        SQLTranslatorContext sqlTranslatorContext = this.translatorRule.translate(new DefaultSQLBuilder(sqlRewriteContext).toSQL(), sqlRewriteContext.getParameterBuilder().getParameters(), queryContext, storageType, this.database, this.globalRuleMetaData);
        return new GenericSQLRewriteResult(new SQLRewriteUnit(sqlTranslatorContext.getSql(), sqlTranslatorContext.getParameters()));
    }

    @Generated
    public GenericSQLRewriteEngine(SQLTranslatorRule translatorRule, ShardingSphereDatabase database, RuleMetaData globalRuleMetaData) {
        this.translatorRule = translatorRule;
        this.database = database;
        this.globalRuleMetaData = globalRuleMetaData;
    }
}

