/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.mock;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import org.apache.shale.test.mock.MockEnumeration;

public class MockHttpSession
implements HttpSession {
    private List attributeListeners = new ArrayList();
    private HashMap attributes = new HashMap();
    private String id = "123";
    private ServletContext servletContext = null;

    public MockHttpSession() {
    }

    public MockHttpSession(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        this.attributeListeners.add(listener);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public Object getValue(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getValueNames() {
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        throw new UnsupportedOperationException();
    }

    public boolean isNew() {
        throw new UnsupportedOperationException();
    }

    public void putValue(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void removeValue(String name) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }

    private void fireAttributeAdded(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.next();
            listener.attributeAdded(event);
        }
    }

    private void fireAttributeRemoved(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.next();
            listener.attributeRemoved(event);
        }
    }

    private void fireAttributeReplaced(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)listeners.next();
            listener.attributeReplaced(event);
        }
    }
}

