/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.io.IOException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ValidatorException;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestUtils;
import org.apache.pluto.testsuite.test.PreferenceCommonTest;

public class PreferenceInRenderTest
extends PreferenceCommonTest {
    protected TestResult checkStorePreferences(PortletRequest request) {
        TestResult result = new TestResult();
        result.setDescription("Ensure that if the store() method is invoked within render() method, an IllegalStateException will be thrown out.");
        result.setSpecPLT("14.1");
        PortletPreferences preferences = request.getPreferences();
        boolean exceptionThrown = false;
        try {
            preferences.store();
        }
        catch (ValidatorException ex) {
            TestUtils.failOnException((String)"Unable to store preferences.", (Throwable)ex, (TestResult)result);
            return result;
        }
        catch (IOException ex) {
            TestUtils.failOnException((String)"Unable to store preferences.", (Throwable)ex, (TestResult)result);
            return result;
        }
        catch (IllegalStateException ex) {
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            result.setReturnCode(2);
        } else {
            result.setReturnCode(1);
            result.setResultMessage("IllegalStateException is not thrown out when store() method is invoked within render() method.");
        }
        return result;
    }
}

