/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.testsuite.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.pluto.testsuite.PortletTest;
import org.apache.pluto.testsuite.TestConfig;
import org.apache.pluto.testsuite.TestResult;
import org.apache.pluto.testsuite.TestResults;
import org.apache.pluto.testsuite.annotations.DefaultTestPhase;
import org.apache.pluto.testsuite.annotations.TestPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReflectivePortletTest
implements PortletTest {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReflectivePortletTest.class);
    private Map<String, String> initParameters;
    private TestConfig config;

    public void init(TestConfig config) {
        this.config = config;
        this.initParameters = config.getInitParameters();
    }

    public Map<String, String[]> getRenderParameters(PortletRequest request) {
        return new HashMap<String, String[]>();
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public String getTestSuiteName() {
        String className = this.getClass().getName();
        int index = className.lastIndexOf(".");
        if (index >= 0 && index < className.length() - 1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public TestResults doTest(PortletConfig config, PortletContext context, PortletRequest request, PortletResponse response) {
        TestResults results = new TestResults(this.getTestSuiteName());
        for (Method method : this.getCheckMethods(request)) {
            try {
                TestResult result = this.invoke(method, config, context, request, response);
                if (result.getName() == null) {
                    result.setName(method.getName());
                }
                results.add(result);
            }
            catch (Throwable th) {
                if (th instanceof InvocationTargetException && th.getCause() != null) {
                    th = th.getCause();
                }
                String message = "Error invoking " + method.getName() + " (" + th.getClass().getName() + "): " + th.getMessage();
                this.errorWithName(message, th);
                TestResult result = new TestResult();
                result.setName(method.getName());
                result.setReturnCode(1);
                result.setResultMessage(message);
                results.add(result);
            }
        }
        return results;
    }

    protected Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    private void debugWithName(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Test [" + this.getTestSuiteName() + "]: " + message);
        }
    }

    private void errorWithName(String message, Throwable cause) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Test [" + this.getTestSuiteName() + "]: " + message, cause);
        }
    }

    private List<Method> getCheckMethods(PortletRequest request) {
        ArrayList<Method> checkMethods = new ArrayList<Method>();
        DefaultTestPhase dtp = this.getClass().getAnnotation(DefaultTestPhase.class);
        String defaultPhase = dtp != null ? dtp.value() : "RENDER_PHASE";
        String lifecyclePhase = (String)request.getAttribute("javax.portlet.lifecycle_phase");
        this.debugWithName("Default phase: " + defaultPhase);
        this.debugWithName("Lifecycle Phase: " + lifecyclePhase);
        for (Class<?> clazz = this.getClass(); clazz != null && AbstractReflectivePortletTest.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String phase;
                int mod = methods[i].getModifiers();
                TestPhase testPhase = methods[i].getAnnotation(TestPhase.class);
                String string = phase = testPhase != null ? testPhase.value() : defaultPhase;
                if (!Modifier.isPublic(mod) && !Modifier.isProtected(mod) || !lifecyclePhase.equals(phase) || Modifier.isAbstract(mod) || !methods[i].getName().startsWith("check")) continue;
                this.debugWithName(" - got check method: " + methods[i].getName());
                checkMethods.add(methods[i]);
            }
        }
        return checkMethods;
    }

    private TestResult invoke(Method method, PortletConfig config, PortletContext context, PortletRequest request, PortletResponse response) throws IllegalAccessException, InvocationTargetException {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] paramValues = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].equals(PortletConfig.class)) {
                paramValues[i] = config;
                continue;
            }
            if (paramTypes[i].equals(PortletContext.class)) {
                paramValues[i] = context;
                continue;
            }
            if (paramTypes[i].isAssignableFrom(request.getClass())) {
                paramValues[i] = request;
                continue;
            }
            if (paramTypes[i].isAssignableFrom(response.getClass())) {
                paramValues[i] = response;
                continue;
            }
            if (!paramTypes[i].equals(PortletSession.class)) continue;
            paramValues[i] = request.getPortletSession();
        }
        TestResult result = (TestResult)method.invoke((Object)this, paramValues);
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append("[initParameters=").append(this.initParameters);
        buffer.append(";config=").append(this.config).append("]");
        return buffer.toString();
    }

    public void doHeaders(PortletConfig config, PortletContext context, RenderRequest request, RenderResponse response) {
    }
}

