/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.container.impl.HttpServletPortletResponseWrapper;
import org.apache.pluto.container.impl.ServletPortletSessionProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletRequestDispatcherImpl
implements PortletRequestDispatcher,
RequestDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(PortletRequestDispatcherImpl.class);
    private RequestDispatcher requestDispatcher;
    private boolean namedDispatch;

    public PortletRequestDispatcherImpl(RequestDispatcher requestDispatcher, boolean namedDispatch) {
        this.requestDispatcher = requestDispatcher;
        this.namedDispatch = namedDispatch;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request dispatcher created.");
        }
    }

    private static HttpServletPortletRequestWrapper getWrappedRequest(ServletRequest request) {
        HttpServletPortletRequestWrapper req = null;
        do {
            if (request instanceof HttpServletPortletRequestWrapper) {
                req = (HttpServletPortletRequestWrapper)((Object)request);
                continue;
            }
            request = request instanceof HttpServletRequestWrapper ? ((HttpServletRequestWrapper)request).getRequest() : null;
        } while (request != null && req == null);
        return req;
    }

    private static HttpServletPortletResponseWrapper getWrappedResponse(ServletResponse response) {
        HttpServletPortletResponseWrapper res = null;
        do {
            if (response instanceof HttpServletPortletResponseWrapper) {
                res = (HttpServletPortletResponseWrapper)((Object)response);
                continue;
            }
            response = response instanceof HttpServletResponseWrapper ? ((HttpServletResponseWrapper)response).getResponse() : null;
        } while (response != null && res == null);
        return res;
    }

    private void doDispatch(PortletRequest request, PortletResponse response, boolean included) throws PortletException, IOException {
        String lifecyclePhase;
        boolean needsFlushAfterForward = false;
        if (!included && ("RENDER_PHASE".equals(lifecyclePhase = (String)request.getAttribute("javax.portlet.lifecycle_phase")) || "RESOURCE_PHASE".equals(lifecyclePhase))) {
            needsFlushAfterForward = true;
            ((MimeResponse)response).resetBuffer();
        }
        PortletRequestContext requestContext = (PortletRequestContext)request.getAttribute(PortletInvokerService.REQUEST_CONTEXT);
        HttpSession session = null;
        if (this.isPortletScopeSessionConfigured(requestContext)) {
            String portletWindowId = requestContext.getPortletWindow().getId().getStringId();
            session = ServletPortletSessionProxy.createProxy(requestContext.getServletRequest(), portletWindowId);
        }
        HttpServletPortletRequestWrapper req = new HttpServletPortletRequestWrapper(requestContext.getServletRequest(), requestContext.getServletContext(), session, request, included, this.namedDispatch);
        HttpServletPortletResponseWrapper res = new HttpServletPortletResponseWrapper(requestContext.getServletResponse(), request, response, included);
        try {
            request.setAttribute("javax.portlet.config", (Object)requestContext.getPortletConfig());
            request.setAttribute("javax.portlet.request", (Object)request);
            request.setAttribute("javax.portlet.response", (Object)response);
            if (!included && req.isForwardingPossible()) {
                this.requestDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            } else {
                this.requestDispatcher.include((ServletRequest)req, (ServletResponse)res);
            }
            if (needsFlushAfterForward) {
                ((MimeResponse)response).flushBuffer();
            }
        }
        catch (ServletException sex) {
            if (sex.getRootCause() != null) {
                throw new PortletException(sex.getRootCause());
            }
            throw new PortletException((Throwable)sex);
        }
        finally {
            request.removeAttribute("javax.portlet.config");
            request.removeAttribute("javax.portlet.request");
            request.removeAttribute("javax.portlet.response");
        }
    }

    private boolean isPortletScopeSessionConfigured(PortletRequestContext requestContext) {
        boolean portletScopeSessionConfigured = false;
        PortletConfig portletConfig = requestContext.getPortletConfig();
        Map containerRuntimeOptions = portletConfig.getContainerRuntimeOptions();
        String[] values = (String[])containerRuntimeOptions.get("javax.portlet.servletDefaultSessionScope");
        if (values != null && values.length > 0) {
            portletScopeSessionConfigured = "PORTLET_SCOPE".equals(values[0]);
        }
        return portletScopeSessionConfigured;
    }

    public void forward(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.doDispatch(request, response, false);
    }

    public void include(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        this.doDispatch(request, response, true);
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.doDispatch((PortletRequest)request, (PortletResponse)response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletPortletRequestWrapper req = PortletRequestDispatcherImpl.getWrappedRequest(request);
        HttpServletPortletResponseWrapper res = PortletRequestDispatcherImpl.getWrappedResponse(response);
        res.resetBuffer();
        boolean forwarded = req.isForwarded();
        boolean namedDispatch = req.isNamedDispatch();
        Map<String, Object> pathAttributeValues = req.getPathAttributeValues();
        HttpServletPortletRequestWrapper.PathMethodValues pathMethodValues = req.getInitPathMethodValues();
        req.setNestedForward();
        try {
            if (req.isForwardingPossible()) {
                this.requestDispatcher.forward(request, response);
            } else {
                this.requestDispatcher.include(request, response);
            }
        }
        finally {
            req.restoreFromNestedForward(forwarded, namedDispatch, pathMethodValues, pathAttributeValues);
        }
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.requestDispatcher.include(request, response);
    }
}

