/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentUtility {
    public static final Logger LOG = LoggerFactory.getLogger(ArgumentUtility.class);

    public static void validateNotNull(String argumentName, Object argument) throws IllegalArgumentException {
        if (argument == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validation failed for argument: " + argumentName + ": argument should not be null.");
            }
            throw new IllegalArgumentException("Illegal Argument: " + argumentName + " (argument should not be null)");
        }
    }

    public static void validateNotEmpty(String argumentName, String argument) throws IllegalArgumentException {
        if (argument == null || "".equals(argument)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Validation failed for argument: " + argumentName + ": argument should not be null or empty.");
            }
            throw new IllegalArgumentException("Illegal Argument: " + argumentName + " (argument should not be null or empty)");
        }
    }
}

