/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.container.impl;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.FilterManager;
import org.apache.pluto.container.PortletActionResponseContext;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletEnvironmentService;
import org.apache.pluto.container.PortletEventResponseContext;
import org.apache.pluto.container.PortletInvokerService;
import org.apache.pluto.container.PortletRenderResponseContext;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletRequestContextService;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletResourceResponseContext;
import org.apache.pluto.container.PortletWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletContainerImpl
implements PortletContainer {
    private static final Logger LOG = LoggerFactory.getLogger(PortletContainerImpl.class);
    private final String name;
    private final ContainerServices containerServices;
    private boolean initialized = false;

    public PortletContainerImpl(String name, ContainerServices requiredServices) {
        this.name = name;
        this.containerServices = requiredServices;
    }

    public void init() throws PortletContainerException {
        this.initialized = true;
        this.infoWithName("Container initialized successfully.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void destroy() {
        this.initialized = false;
        this.infoWithName("Container destroyed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Render request received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletRequestContext requestContext = rcService.getPortletRenderRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletRenderResponseContext responseContext = rcService.getPortletRenderResponseContext((PortletContainer)this, request, response, portletWindow);
        RenderRequest portletRequest = envService.createRenderRequest(requestContext, responseContext);
        RenderResponse portletResponse = envService.createRenderResponse(responseContext);
        FilterManager filterManager = this.filterInitialisation(portletWindow, "RENDER_PHASE");
        try {
            invoker.render(requestContext, portletRequest, portletResponse, filterManager);
            responseContext.close();
        }
        finally {
            responseContext.release();
        }
        this.debugWithName("Portlet render done for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doServeResource(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Resource request received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletResourceRequestContext requestContext = rcService.getPortletResourceRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletResourceResponseContext responseContext = rcService.getPortletResourceResponseContext((PortletContainer)this, request, response, portletWindow);
        ResourceRequest portletRequest = envService.createResourceRequest(requestContext, responseContext);
        ResourceResponse portletResponse = envService.createResourceResponse(responseContext, requestContext.getCacheability());
        FilterManager filterManager = this.filterInitialisation(portletWindow, "RESOURCE_PHASE");
        try {
            invoker.serveResource((PortletRequestContext)requestContext, portletRequest, portletResponse, filterManager);
            responseContext.close();
        }
        finally {
            responseContext.release();
        }
        this.debugWithName("Portlet resource done for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Action request received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletRequestContext requestContext = rcService.getPortletActionRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletActionResponseContext responseContext = rcService.getPortletActionResponseContext((PortletContainer)this, request, response, portletWindow);
        ActionRequest portletRequest = envService.createActionRequest(requestContext, responseContext);
        ActionResponse portletResponse = envService.createActionResponse(responseContext);
        FilterManager filterManager = this.filterInitialisation(portletWindow, "ACTION_PHASE");
        String location = null;
        try {
            List events;
            invoker.action(requestContext, portletRequest, portletResponse, filterManager);
            this.debugWithName("Portlet action processed for: " + portletWindow.getPortletDefinition().getPortletName());
            responseContext.close();
            if (!responseContext.isRedirect() && !(events = responseContext.getEvents()).isEmpty()) {
                this.getContainerServices().getEventCoordinationService().processEvents((PortletContainer)this, portletWindow, request, response, events);
            }
            location = response.encodeRedirectURL(responseContext.getResponseURL());
        }
        finally {
            responseContext.release();
        }
        this.redirect(request, response, location);
        this.debugWithName("Portlet action done for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    protected void redirect(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        response.sendRedirect(location);
        this.debugWithName("Redirect URL sent.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Load request received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletRequestContext requestContext = rcService.getPortletRenderRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletRenderResponseContext responseContext = rcService.getPortletRenderResponseContext((PortletContainer)this, request, response, portletWindow);
        RenderRequest portletRequest = envService.createRenderRequest(requestContext, responseContext);
        RenderResponse portletResponse = envService.createRenderResponse(responseContext);
        try {
            invoker.load(requestContext, (PortletRequest)portletRequest, (PortletResponse)portletResponse);
            responseContext.close();
        }
        finally {
            responseContext.release();
        }
        this.debugWithName("Portlet load done for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdmin(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Admin request received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletRequestContext requestContext = rcService.getPortletRenderRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletRenderResponseContext responseContext = rcService.getPortletRenderResponseContext((PortletContainer)this, request, response, portletWindow);
        RenderRequest portletRequest = envService.createRenderRequest(requestContext, responseContext);
        RenderResponse portletResponse = envService.createRenderResponse(responseContext);
        try {
            invoker.admin(requestContext, (PortletRequest)portletRequest, (PortletResponse)portletResponse);
            responseContext.close();
        }
        finally {
            responseContext.release();
        }
        this.debugWithName("Portlet admin request done for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    public String getName() {
        return this.name;
    }

    public ContainerServices getContainerServices() {
        return this.containerServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response, Event event) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        this.debugWithName("Event: " + event.getName() + " received for portlet: " + portletWindow.getPortletDefinition().getPortletName());
        PortletRequestContextService rcService = this.getContainerServices().getPortletRequestContextService();
        PortletEnvironmentService envService = this.getContainerServices().getPortletEnvironmentService();
        PortletInvokerService invoker = this.getContainerServices().getPortletInvokerService();
        PortletRequestContext requestContext = rcService.getPortletEventRequestContext((PortletContainer)this, request, response, portletWindow);
        PortletEventResponseContext responseContext = rcService.getPortletEventResponseContext((PortletContainer)this, request, response, portletWindow);
        EventRequest portletRequest = envService.createEventRequest(requestContext, responseContext, event);
        EventResponse portletResponse = envService.createEventResponse(responseContext);
        FilterManager filterManager = this.filterInitialisation(portletWindow, "EVENT_PHASE");
        List events = null;
        try {
            invoker.event(requestContext, portletRequest, portletResponse, filterManager);
            this.debugWithName("Portlet event processed for: " + portletWindow.getPortletDefinition().getPortletName());
            responseContext.close();
            events = responseContext.getEvents();
        }
        finally {
            responseContext.release();
        }
        if (events != null && !events.isEmpty()) {
            this.getContainerServices().getEventCoordinationService().processEvents((PortletContainer)this, portletWindow, request, response, events);
        }
        this.debugWithName("Portlet event: " + event.getName() + " fired for: " + portletWindow.getPortletDefinition().getPortletName());
    }

    private void ensureInitialized() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Portlet container [" + this.name + "] is not initialized.");
        }
    }

    private void debugWithName(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Portlet Container [" + this.name + "]: " + message);
        }
    }

    private void infoWithName(String message) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Portlet Container [" + this.name + "]: " + message);
        }
    }

    private FilterManager filterInitialisation(PortletWindow portletWindow, String lifeCycle) throws PortletContainerException {
        return this.getContainerServices().getFilterManagerService().getFilterManager(portletWindow, lifeCycle);
    }
}

