/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.util.Enumeration;
import java.util.Vector;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.util.ArgumentUtility;

public class PortletSessionImpl
implements PortletSession,
HttpSession {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$PortletSessionImpl == null ? (class$org$apache$pluto$internal$impl$PortletSessionImpl = PortletSessionImpl.class$("org.apache.pluto.internal.impl.PortletSessionImpl")) : class$org$apache$pluto$internal$impl$PortletSessionImpl));
    private static final int DEFAULT_SCOPE = 2;
    private static final String PORTLET_SCOPE_NAMESPACE = "javax.portlet.p.";
    private static final char ID_NAME_SEPARATOR = '?';
    private final HttpSession httpSession;
    private final PortletContext portletContext;
    private final InternalPortletWindow internalPortletWindow;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletSessionImpl;

    public PortletSessionImpl(PortletContext portletContext, InternalPortletWindow internalPortletWindow, HttpSession httpSession) {
        this.portletContext = portletContext;
        this.internalPortletWindow = internalPortletWindow;
        this.httpSession = httpSession;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        String key = scope == 1 ? name : this.createPortletScopedId(name);
        return this.httpSession.getAttribute(key);
    }

    public Enumeration getAttributeNames() {
        return this.getAttributeNames(2);
    }

    public Enumeration getAttributeNames(int scope) {
        if (scope == 1) {
            return this.httpSession.getAttributeNames();
        }
        Vector<String> portletScopedNames = new Vector<String>();
        Enumeration en = this.httpSession.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            if (!this.isInCurrentPortletScope(name)) continue;
            portletScopedNames.add(PortletSessionUtil.decodeAttributeName((String)name));
        }
        return portletScopedNames.elements();
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if (scope == 1) {
            this.httpSession.removeAttribute(name);
        } else {
            this.httpSession.removeAttribute(this.createPortletScopedId(name));
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void setAttribute(String name, Object value, int scope) {
        ArgumentUtility.validateNotNull("attributeName", name);
        if (scope == 1) {
            this.httpSession.setAttribute(name, value);
        } else {
            this.httpSession.setAttribute(this.createPortletScopedId(name), value);
        }
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public long getCreationTime() {
        return this.httpSession.getCreationTime();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public long getLastAccessedTime() {
        return this.httpSession.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.httpSession.getMaxInactiveInterval();
    }

    public void invalidate() throws IllegalStateException {
        this.httpSession.invalidate();
    }

    public boolean isNew() throws IllegalStateException {
        return this.httpSession.isNew();
    }

    public void setMaxInactiveInterval(int interval) {
        this.httpSession.setMaxInactiveInterval(interval);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Session timeout set to: " + interval));
        }
    }

    private String createPortletScopedId(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PORTLET_SCOPE_NAMESPACE);
        buffer.append(this.internalPortletWindow.getId().getStringId());
        buffer.append('?');
        buffer.append(name);
        return buffer.toString();
    }

    private boolean isInCurrentPortletScope(String name) {
        if (name.startsWith(PORTLET_SCOPE_NAMESPACE) && name.indexOf(63) > -1) {
            String id = name.substring(PORTLET_SCOPE_NAMESPACE.length(), name.indexOf(63));
            return id.equals(this.internalPortletWindow.getId().getStringId());
        }
        return false;
    }

    public ServletContext getServletContext() {
        return this.httpSession.getServletContext();
    }

    public HttpSessionContext getSessionContext() {
        return this.httpSession.getSessionContext();
    }

    public Object getValue(String name) {
        return this.getAttribute(name, 2);
    }

    public String[] getValueNames() {
        return this.httpSession.getValueNames();
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value, 2);
    }

    public void removeValue(String name) {
        this.removeAttribute(name, 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

