/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.core;

import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.PortletWindow;
import org.apache.pluto.RequiredContainerServices;
import org.apache.pluto.core.ContainerInvocation;
import org.apache.pluto.core.PortletContextManager;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.internal.InternalActionRequest;
import org.apache.pluto.internal.InternalActionResponse;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.internal.InternalRenderRequest;
import org.apache.pluto.internal.InternalRenderResponse;
import org.apache.pluto.internal.PortletDescriptorRegistry;
import org.apache.pluto.internal.impl.InternalPortletWindowImpl;
import org.apache.pluto.internal.impl.PortletRequestImpl;
import org.apache.pluto.internal.impl.PortletResponseImpl;
import org.apache.pluto.spi.PortletURLProvider;
import org.apache.pluto.spi.optional.PortletInvokerService;
import org.apache.pluto.util.StringManager;

public class PortletContainerImpl
implements PortletContainer {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$core$PortletContainerImpl == null ? (class$org$apache$pluto$core$PortletContainerImpl = PortletContainerImpl.class$("org.apache.pluto.core.PortletContainerImpl")) : class$org$apache$pluto$core$PortletContainerImpl));
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$core$PortletContainerImpl == null ? (class$org$apache$pluto$core$PortletContainerImpl = PortletContainerImpl.class$("org.apache.pluto.core.PortletContainerImpl")) : class$org$apache$pluto$core$PortletContainerImpl).getPackage().getName());
    private final String name;
    private final RequiredContainerServices requiredContainerServices;
    private final OptionalContainerServices optionalContainerServices;
    private ServletContext servletContext;
    private boolean initialized = false;
    static /* synthetic */ Class class$org$apache$pluto$core$PortletContainerImpl;

    public PortletContainerImpl(String name, RequiredContainerServices requiredServices, OptionalContainerServices optionalServices) {
        this.name = name;
        this.requiredContainerServices = requiredServices;
        this.optionalContainerServices = optionalServices;
    }

    public void init(ServletContext servletContext) throws PortletContainerException {
        if (servletContext == null) {
            throw new PortletContainerException("Unable to initialize portlet container [" + this.name + "]: " + "servlet context is null.");
        }
        this.servletContext = servletContext;
        this.initialized = true;
        this.infoWithName("Container initialized successfully.");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void destroy() {
        this.servletContext = null;
        this.initialized = false;
        this.infoWithName("Container destroyed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        ServletContext portletAppCtx = this.getPortletAppContext(portletWindow.getContextPath());
        InternalPortletWindowImpl internalPortletWindow = new InternalPortletWindowImpl(portletAppCtx, portletWindow);
        this.debugWithName("Render request received for portlet: " + portletWindow.getPortletName());
        InternalRenderRequest renderRequest = this.getOptionalContainerServices().getPortletEnvironmentService().createRenderRequest(this, request, response, internalPortletWindow);
        InternalRenderResponse renderResponse = this.getOptionalContainerServices().getPortletEnvironmentService().createRenderResponse(this, request, response, internalPortletWindow);
        PortletInvokerService invoker = this.optionalContainerServices.getPortletInvokerService();
        try {
            ContainerInvocation.setInvocation(this, internalPortletWindow);
            invoker.render(renderRequest, renderResponse, internalPortletWindow);
        }
        finally {
            ContainerInvocation.clearInvocation();
        }
        this.debugWithName("Portlet rendered for: " + portletWindow.getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        ServletContext portletAppCtx = this.getPortletAppContext(portletWindow.getContextPath());
        InternalPortletWindowImpl internalPortletWindow = new InternalPortletWindowImpl(portletAppCtx, portletWindow);
        this.debugWithName("Action request received for portlet: " + portletWindow.getPortletName());
        InternalActionRequest actionRequest = this.getOptionalContainerServices().getPortletEnvironmentService().createActionRequest(this, request, response, internalPortletWindow);
        InternalActionResponse actionResponse = this.getOptionalContainerServices().getPortletEnvironmentService().createActionResponse(this, request, response, internalPortletWindow);
        PortletInvokerService invoker = this.optionalContainerServices.getPortletInvokerService();
        try {
            ContainerInvocation.setInvocation(this, internalPortletWindow);
            invoker.action(actionRequest, actionResponse, internalPortletWindow);
        }
        finally {
            ContainerInvocation.clearInvocation();
        }
        this.debugWithName("Portlet action processed for: " + portletWindow.getPortletName());
        String location = actionResponse.getRedirectLocation();
        if (location == null) {
            this.debugWithName("No redirect location specified.");
            PortletURLProvider redirectURL = this.requiredContainerServices.getPortalCallbackService().getPortletURLProvider(request, internalPortletWindow);
            if (actionResponse.getChangedPortletMode() != null) {
                redirectURL.setPortletMode(actionResponse.getChangedPortletMode());
            }
            if (actionResponse.getChangedWindowState() != null) {
                redirectURL.setWindowState(actionResponse.getChangedWindowState());
            }
            Map renderParameters = actionResponse.getRenderParameters();
            redirectURL.clearParameters();
            redirectURL.setParameters(renderParameters);
            redirectURL.setAction(false);
            if (redirectURL.isSecureSupported()) {
                redirectURL.setSecure();
            }
            location = actionResponse.encodeRedirectURL(((Object)redirectURL).toString());
        }
        response.sendRedirect(location);
        this.debugWithName("Redirect URL sent.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad(PortletWindow portletWindow, HttpServletRequest request, HttpServletResponse response) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        ServletContext portletAppCtx = this.getPortletAppContext(portletWindow.getContextPath());
        InternalPortletWindowImpl internalPortletWindow = new InternalPortletWindowImpl(portletAppCtx, portletWindow);
        this.debugWithName("Load request received for portlet: " + portletWindow.getPortletName());
        InternalRenderRequest renderRequest = this.getOptionalContainerServices().getPortletEnvironmentService().createRenderRequest(this, request, response, internalPortletWindow);
        InternalRenderResponse renderResponse = this.getOptionalContainerServices().getPortletEnvironmentService().createRenderResponse(this, request, response, internalPortletWindow);
        PortletInvokerService invoker = this.optionalContainerServices.getPortletInvokerService();
        try {
            ContainerInvocation.setInvocation(this, internalPortletWindow);
            invoker.load(renderRequest, renderResponse, internalPortletWindow);
        }
        finally {
            ContainerInvocation.clearInvocation();
        }
        this.debugWithName("Portlet loaded for: " + portletWindow.getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAdmin(PortletWindow portletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws PortletException, IOException, PortletContainerException {
        this.ensureInitialized();
        ServletContext portletAppCtx = this.getPortletAppContext(portletWindow.getContextPath());
        InternalPortletWindowImpl internalPortletWindow = new InternalPortletWindowImpl(portletAppCtx, portletWindow);
        this.debugWithName("Admin request received for portlet: " + portletWindow.getPortletName());
        AdminRequest internalRequest = new AdminRequest(this, internalPortletWindow, servletRequest){};
        AdminResponse internalResponse = new AdminResponse(this, internalPortletWindow, servletRequest, servletResponse);
        PortletInvokerService invoker = this.optionalContainerServices.getPortletInvokerService();
        try {
            ContainerInvocation.setInvocation(this, internalPortletWindow);
            invoker.admin(internalRequest, internalResponse, internalPortletWindow);
        }
        finally {
            ContainerInvocation.clearInvocation();
        }
        this.debugWithName("Admin request complete.");
    }

    public String getName() {
        return this.name;
    }

    public RequiredContainerServices getRequiredContainerServices() {
        return this.requiredContainerServices;
    }

    public OptionalContainerServices getOptionalContainerServices() {
        return this.optionalContainerServices;
    }

    public PortletAppDD getPortletApplicationDescriptor(String context) throws PortletContainerException {
        this.ensureInitialized();
        if (context == null || context.trim().equals("")) {
            String msg = "Context was null or the empty string.";
            this.errorWithName("Context was null or the empty string.");
            throw new PortletContainerException("Context was null or the empty string.");
        }
        ServletContext portletCtx = this.getPortletAppContext(context);
        PortletAppDD portletAppDD = PortletDescriptorRegistry.getRegistry().getPortletAppDD(portletCtx);
        if (portletAppDD == null) {
            String msg = "Obtained a null portlet application description for portlet context [" + context + "]";
            this.errorWithName(msg);
            throw new PortletContainerException(msg);
        }
        return portletAppDD;
    }

    private void ensureInitialized() throws IllegalStateException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Portlet container [" + this.name + "] is not initialized.");
        }
    }

    private ServletContext getPortletAppContext(String portletAppContextPath) throws PortletContainerException {
        ServletContext portletAppCtx = PortletContextManager.getPortletContext(this.servletContext, portletAppContextPath);
        if (portletAppCtx == null) {
            String msg = "Unable to obtain the servlet context for the portlet app context path [" + portletAppContextPath + "]. Make " + "sure that the portlet app has been deployed, and that cross " + "context support is enabled for the portal app.";
            throw new PortletContainerException(msg);
        }
        return portletAppCtx;
    }

    private void debugWithName(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Portlet Container [" + this.name + "]: " + message));
        }
    }

    private void infoWithName(String message) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Portlet Container [" + this.name + "]: " + message));
        }
    }

    private void errorWithName(String message) {
        if (LOG.isErrorEnabled()) {
            LOG.info((Object)("Portlet Container [" + this.name + "]: " + message));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class AdminResponse
    extends PortletResponseImpl {
        public AdminResponse(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
            super(container, internalPortletWindow, servletRequest, servletResponse);
        }
    }

    class AdminRequest
    extends PortletRequestImpl {
        public AdminRequest(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest) {
            super(container, internalPortletWindow, servletRequest);
        }

        public PortletPreferences getPreferences() {
            throw new IllegalStateException("Can not access preferences during admin request.");
        }
    }
}

