/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.imageio;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.tools.imageio.JPEGUtil;
import org.apache.pdfbox.tools.imageio.TIFFUtil;
import org.w3c.dom.NodeList;

public final class ImageIOUtil {
    private static final Log LOG = LogFactory.getLog(ImageIOUtil.class);

    private ImageIOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeImage(BufferedImage image, String filename, int dpi) throws IOException {
        File file = new File(filename);
        FileOutputStream output = new FileOutputStream(file);
        try {
            String formatName = filename.substring(filename.lastIndexOf(46) + 1);
            boolean bl = ImageIOUtil.writeImage(image, formatName, output, dpi);
            return bl;
        }
        finally {
            output.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean writeImage(BufferedImage image, String formatName, String filename, int dpi) throws IOException {
        File file = new File(filename + "." + formatName);
        FileOutputStream output = new FileOutputStream(file);
        try {
            boolean bl = ImageIOUtil.writeImage(image, formatName, output, dpi);
            return bl;
        }
        finally {
            output.close();
        }
    }

    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output) throws IOException {
        return ImageIOUtil.writeImage(image, formatName, output, 72);
    }

    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output, int dpi) throws IOException {
        return ImageIOUtil.writeImage(image, formatName, output, dpi, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeImage(BufferedImage image, String formatName, OutputStream output, int dpi, float quality) throws IOException {
        ImageInputStream imageOutput = null;
        ImageWriter writer = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
            ImageWriteParam param = null;
            IIOMetadata metadata = null;
            while (writers.hasNext()) {
                if (writer != null) {
                    writer.dispose();
                }
                if ((metadata = (writer = writers.next()).getDefaultImageMetadata(new ImageTypeSpecifier(image), param = writer.getDefaultWriteParam())) == null || metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            }
            if (writer == null) {
                String[] writerFormatNames;
                LOG.error((Object)("No ImageWriter found for '" + formatName + "' format"));
                StringBuilder sb = new StringBuilder();
                for (String fmt : writerFormatNames = ImageIO.getWriterFormatNames()) {
                    sb.append(fmt);
                    sb.append(' ');
                }
                LOG.error((Object)("Supported formats: " + sb));
                boolean bl = false;
                return bl;
            }
            if (param != null && param.canWriteCompressed()) {
                param.setCompressionMode(2);
                if (formatName.toLowerCase().startsWith("tif")) {
                    TIFFUtil.setCompressionType(param, image);
                } else {
                    param.setCompressionType(param.getCompressionTypes()[0]);
                    param.setCompressionQuality(quality);
                }
            }
            if (formatName.toLowerCase().startsWith("tif")) {
                TIFFUtil.updateMetadata(metadata, image, dpi);
            } else if ("jpeg".equals(formatName.toLowerCase()) || "jpg".equals(formatName.toLowerCase())) {
                JPEGUtil.updateMetadata(metadata, dpi);
            } else if (metadata != null && !metadata.isReadOnly() && metadata.isStandardMetadataFormatSupported()) {
                ImageIOUtil.setDPI(metadata, dpi, formatName);
            }
            imageOutput = ImageIO.createImageOutputStream(output);
            writer.setOutput(imageOutput);
            writer.write(null, new IIOImage(image, null, metadata), param);
        }
        finally {
            if (writer != null) {
                writer.dispose();
            }
            if (imageOutput != null) {
                imageOutput.close();
            }
        }
        return true;
    }

    private static IIOMetadataNode getOrCreateChildNode(IIOMetadataNode parentNode, String name) {
        NodeList nodeList = parentNode.getElementsByTagName(name);
        if (nodeList != null && nodeList.getLength() > 0) {
            return (IIOMetadataNode)nodeList.item(0);
        }
        IIOMetadataNode childNode = new IIOMetadataNode(name);
        parentNode.appendChild(childNode);
        return childNode;
    }

    private static void setDPI(IIOMetadata metadata, int dpi, String formatName) throws IIOInvalidTreeException {
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        IIOMetadataNode dimension = ImageIOUtil.getOrCreateChildNode(root, "Dimension");
        float res = "PNG".equals(formatName.toUpperCase()) ? (float)dpi / 25.4f : 25.4f / (float)dpi;
        IIOMetadataNode child = ImageIOUtil.getOrCreateChildNode(dimension, "HorizontalPixelSize");
        child.setAttribute("value", Double.toString(res));
        child = ImageIOUtil.getOrCreateChildNode(dimension, "VerticalPixelSize");
        child.setAttribute("value", Double.toString(res));
        metadata.mergeTree("javax_imageio_1.0", root);
    }
}

