/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.encoding;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Encoding {
    protected Map codeToName = new HashMap();
    protected Map nameToCode = new HashMap();
    private static final Map NAME_TO_CHARACTER = new HashMap();
    private static final Map CHARACTER_TO_NAME = new HashMap();

    protected void addCharacterEncoding(int code, String name) {
        Integer intCode = new Integer(code);
        this.codeToName.put(intCode, name);
        this.nameToCode.put(name, intCode);
    }

    public int getCode(String name) throws IOException {
        Integer code = (Integer)this.nameToCode.get(name);
        if (code == null) {
            throw new IOException("No character code for character name '" + name + "'");
        }
        return code;
    }

    public String getName(int code) throws IOException {
        String name = (String)this.codeToName.get(new Integer(code));
        if (name == null) {
            name = "space";
        }
        return name;
    }

    public String getNameFromCharacter(char c) throws IOException {
        String name = (String)CHARACTER_TO_NAME.get("" + c);
        if (name == null) {
            throw new IOException("No name for character '" + c + "'");
        }
        return name;
    }

    public String getCharacter(int code) throws IOException {
        String character = Encoding.getCharacter(this.getName(code));
        return character;
    }

    public static String getCharacter(String name) {
        String character = (String)NAME_TO_CHARACTER.get(name);
        if (character == null) {
            character = name;
        }
        return character;
    }
}

