/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Provider;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.util.WebBeansUtil;

public class ProviderBasedProducer<T>
extends AbstractProducer<T> {
    private WebBeansContext webBeansContext;
    private Class<T> returnType;
    private Provider<T> provider;
    private T proxyInstance;
    private boolean proxy;

    public ProviderBasedProducer(WebBeansContext webBeansContext, Class<T> returnType, Provider<T> provider, boolean proxy) {
        this.webBeansContext = webBeansContext;
        this.returnType = returnType;
        this.provider = provider;
        this.proxy = proxy;
    }

    public T produce(CreationalContext<T> creationalContext) {
        if (this.proxyInstance == null) {
            if (this.proxy) {
                NormalScopeProxyFactory proxyFactory = this.webBeansContext.getNormalScopeProxyFactory();
                ClassLoader loader = this.returnType.getClassLoader();
                if (loader == null) {
                    loader = WebBeansUtil.getCurrentClassLoader();
                }
                Class<T> proxyClass = proxyFactory.createProxyClass(loader, this.returnType);
                this.proxyInstance = proxyFactory.createProxyInstance(proxyClass, this.provider);
            } else {
                this.proxyInstance = this.provider.get();
            }
        }
        return this.proxyInstance;
    }
}

