/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.conversation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.Asserts;

public class ConversationManager {
    private final ConcurrentHashMap<Conversation, ConversationContext> conversations = new ConcurrentHashMap();
    private final WebBeansContext webBeansContext;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(ConversationManager.class);

    public ConversationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void addConversationContext(Conversation conversation, ConversationContext context) {
        this.conversations.put(conversation, context);
    }

    public boolean isConversationExistWithGivenId(String conversationId) {
        ConversationImpl conv2 = null;
        Set set = this.conversations.keySet();
        for (ConversationImpl conv2 : set) {
            if (!conv2.getId().equals(conversationId)) continue;
            return true;
        }
        return false;
    }

    public Map<Conversation, ConversationContext> getConversationMapWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        ConversationImpl conv = null;
        HashMap<Conversation, ConversationContext> map = new HashMap<Conversation, ConversationContext>();
        while (it.hasNext()) {
            conv = (ConversationImpl)it.next();
            if (!conv.getSessionId().equals(sessionId)) continue;
            map.put(conv, this.conversations.get(conv));
        }
        return map;
    }

    public Map<Conversation, ConversationContext> getAndRemoveConversationMapWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        ConversationImpl conv = null;
        HashMap<Conversation, ConversationContext> map = new HashMap<Conversation, ConversationContext>();
        while (it.hasNext()) {
            conv = (ConversationImpl)it.next();
            if (!conv.getSessionId().equals(sessionId)) continue;
            map.put(conv, this.conversations.remove(conv));
        }
        return map;
    }

    public ConversationContext removeConversation(Conversation conversation) {
        Asserts.assertNotNull(conversation, "conversation can not be null");
        return this.conversations.remove(conversation);
    }

    public ConversationContext getConversationContext(Conversation conversation) {
        Asserts.assertNotNull(conversation, "conversation can not be null");
        return this.conversations.get(conversation);
    }

    public ConversationImpl getPropogatedConversation(String conversationId, String sessionId) {
        Asserts.assertNotNull(conversationId, "conversationId parameter can not be null");
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Set set = this.conversations.keySet();
        for (ConversationImpl conv : set) {
            if (!conv.getId().equals(conversationId) || !conv.getSessionId().equals(sessionId)) continue;
            return conv;
        }
        return null;
    }

    @Deprecated
    public void destroyConversationContextWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            ConversationImpl conv = (ConversationImpl)it.next();
            if (!conv.getSessionId().equals(sessionId)) continue;
            ConversationContext ctx = this.getConversationContext(conv);
            if (ctx != null) {
                ctx.destroy();
            }
            it.remove();
        }
    }

    public Conversation getConversationBeanReference() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        Bean bean = (Bean)beanManager.getBeans((Type)((Object)Conversation.class), new Annotation[]{DefaultLiteral.INSTANCE}).iterator().next();
        Conversation conversation = (Conversation)beanManager.getReference(bean, (Type)((Object)Conversation.class), beanManager.createCreationalContext((Contextual)bean));
        return conversation;
    }

    public void destroyWithRespectToTimout() {
        ConversationImpl conv = null;
        Set set = this.conversations.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            conv = (ConversationImpl)it.next();
            long timeout = conv.getTimeout();
            if (timeout == 0L || System.currentTimeMillis() - conv.getActiveTime() <= timeout) continue;
            ConversationContext ctx = this.getConversationContext(conv);
            if (ctx != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "INFO_0011", conv.getId());
                }
                ctx.destroy();
            }
            it.remove();
        }
    }

    public Map<Conversation, ConversationContext> getAllConversationContexts() {
        return this.conversations;
    }
}

