/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.SecurityUtil;

public class DeploymentValidationService {
    private WebBeansContext webBeansContext;

    public DeploymentValidationService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void validateProxyable(OwbBean<?> bean) {
        if (this.webBeansContext.getBeanManagerImpl().isNormalScope(bean.getScope())) {
            ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation();
            Class<?> beanClass = bean.getReturnType();
            if (!beanClass.isInterface() && beanClass != Object.class) {
                if (beanClass.isPrimitive()) {
                    violationMessage.addLine("It isn't possible to proxy a primitive type (" + beanClass.getName(), ")");
                }
                if (beanClass.isArray()) {
                    violationMessage.addLine("It isn't possible to proxy an array type (", beanClass.getName(), ")");
                }
                if (!violationMessage.containsViolation()) {
                    Method[] methods;
                    if (Modifier.isFinal(beanClass.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " is a final class! CDI doesn't allow to proxy that.");
                    }
                    for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(beanClass)) {
                        int modifiers = m.getModifiers();
                        if (!Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || m.isSynthetic() || m.isBridge()) continue;
                        violationMessage.addLine(beanClass.getName(), " has final method " + m + " CDI doesn't allow to proxy that.");
                    }
                    Constructor<?> cons = this.webBeansContext.getWebBeansUtil().getNoArgConstructor(beanClass);
                    if (cons == null) {
                        violationMessage.addLine(beanClass.getName(), " has no explicit no-arg constructor!", "A public or protected constructor without args is required!");
                    } else if (Modifier.isPrivate(cons.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " has a >private< no-arg constructor! CDI doesn't allow to proxy that.");
                    }
                }
                if (violationMessage.containsViolation()) {
                    InjectionExceptionUtil.throwUnproxyableResolutionException(violationMessage);
                }
            }
        }
    }

    public <T> void validatePassivationCapable(OwbBean<T> bean) {
        if (this.isPassivationCapable(bean)) {
            InjectionTargetImpl injectionTarget;
            InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
            if (!(bean instanceof ProducerMethodBean)) {
                this.validatePassivationCapableDependencies(bean, bean.getInjectionPoints());
            }
            if (bean.getProducer() instanceof InjectionTargetImpl && (interceptorInfo = (injectionTarget = (InjectionTargetImpl)bean.getProducer()).getInterceptorInfo()) != null) {
                for (Interceptor interceptor : interceptorInfo.getEjbInterceptors()) {
                    this.validatePassivationCapableDependency(bean, (Bean<?>)interceptor);
                }
                for (Interceptor interceptor : interceptorInfo.getCdiInterceptors()) {
                    this.validatePassivationCapableDependency(bean, (Bean<?>)interceptor);
                }
                for (Decorator decorator : interceptorInfo.getDecorators()) {
                    this.validatePassivationCapableDependency(bean, (Bean<?>)decorator);
                }
            }
        }
    }

    private <T> void validatePassivationCapableDependency(Bean<T> bean, Bean<?> dependentBean) {
        if (!this.isPassivationCapable(dependentBean)) {
            String type = dependentBean instanceof Interceptor ? "Interceptor " : "Decorator ";
            throw new WebBeansConfigurationException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + bean.toString() + " does not satisfy. " + type + dependentBean.toString() + " is not passivation capable");
        }
        this.validatePassivationCapableDependencies(bean, dependentBean.getInjectionPoints());
    }

    private <T> void validatePassivationCapableDependencies(Bean<T> bean, Set<InjectionPoint> injectionPoints) {
        for (InjectionPoint injectionPoint : injectionPoints) {
            if (injectionPoint.isTransient() || this.webBeansContext.getWebBeansUtil().isPassivationCapableDependency(injectionPoint) || injectionPoint.getAnnotated().isAnnotationPresent(Disposes.class)) continue;
            throw new WebBeansConfigurationException("Passivation capable beans must satisfy passivation capable dependencies. Bean : " + bean.toString() + " does not satisfy. Details about the Injection-point: " + injectionPoint.toString());
        }
    }

    private boolean isPassivationCapable(Bean<?> bean) {
        return bean instanceof OwbBean ? ((OwbBean)bean).isPassivationCapable() : bean instanceof PassivationCapable;
    }
}

