/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import opennlp.tools.ml.naivebayes.Probability;

public abstract class Probabilities<T> {
    protected HashMap<T, Double> map = new HashMap();
    protected transient boolean isNormalised = false;
    protected Map<T, Double> normalised;
    protected double confidence = 0.0;

    public void set(T t, double probability) {
        this.isNormalised = false;
        this.map.put(t, probability);
    }

    public void set(T t, Probability<T> probability) {
        this.isNormalised = false;
        this.map.put(t, probability.get());
    }

    public void setIfLarger(T t, double probability) {
        Double p = this.map.get(t);
        if (p == null || probability > p) {
            this.isNormalised = false;
            this.map.put(t, probability);
        }
    }

    public void setLog(T t, double probability) {
        this.set(t, Math.exp(probability));
    }

    public void addIn(T t, double probability, int count) {
        this.isNormalised = false;
        Double p = this.map.get(t);
        if (p == null) {
            p = 1.0;
        }
        probability = Math.pow(probability, count);
        this.map.put(t, p * probability);
    }

    public Double get(T t) {
        Double d = this.normalize().get(t);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public Double getLog(T t) {
        return Math.log(this.get(t));
    }

    public Set<T> getKeys() {
        return this.map.keySet();
    }

    public Map<T, Double> getAll() {
        return this.normalize();
    }

    private Map<T, Double> normalize() {
        Double p;
        if (this.isNormalised) {
            return this.normalised;
        }
        Map<T, Double> temp = this.createMapDataStructure();
        double sum = 0.0;
        for (T t : this.map.keySet()) {
            p = this.map.get(t);
            if (p == null) continue;
            sum += p.doubleValue();
        }
        for (T t : temp.keySet()) {
            p = temp.get(t);
            if (p == null) continue;
            temp.put(t, p / sum);
        }
        this.normalised = temp;
        this.isNormalised = true;
        return temp;
    }

    protected Map<T, Double> createMapDataStructure() {
        return new HashMap();
    }

    public T getMax() {
        double max = 0.0;
        T maxT = null;
        for (T t : this.map.keySet()) {
            Double temp = this.map.get(t);
            if (!(temp >= max)) continue;
            max = temp;
            maxT = t;
        }
        return maxT;
    }

    public double getMaxValue() {
        return this.get(this.getMax());
    }

    public void discardCountsBelow(double i) {
        ArrayList<T> labelsToRemove = new ArrayList<T>();
        for (Object label : this.map.keySet()) {
            Double sum = this.map.get(label);
            if (sum == null) {
                sum = 0.0;
            }
            if (!(sum < i)) continue;
            labelsToRemove.add(label);
        }
        for (Object label : labelsToRemove) {
            this.map.remove(label);
        }
    }

    public double getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    public String toString() {
        return this.getAll().toString();
    }
}

