/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.reflect.Method;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.TupleFactory;

public class TupleImpl
implements Tuple {
    private static final Localizer _loc = Localizer.forPackage(TupleImpl.class);
    private final TupleFactory factory;
    private final Object[] values;
    public static Method PUT;

    TupleImpl(TupleFactory factory) {
        this.factory = factory;
        this.values = new Object[factory.getElements().size()];
    }

    public <X> X get(TupleElement<X> tupleElement) {
        int i = this.factory.getIndex(tupleElement);
        return this.assertAndConvertType("" + i, this.values[i], tupleElement.getJavaType());
    }

    public <X> X get(String alias, Class<X> type) {
        Object val = this.values[this.factory.getIndex(alias)];
        return this.assertAndConvertType(alias, val, type);
    }

    public Object get(String alias) {
        return this.get(alias, null);
    }

    public <X> X get(int i, Class<X> type) {
        if (i >= this.values.length || i < 0) {
            throw new IllegalArgumentException(_loc.get("tuple-exceeded-size", i, this.values.length).getMessage());
        }
        Object val = this.values[i];
        return this.assertAndConvertType("" + i, val, type);
    }

    public Object get(int i) {
        return this.get(i, null);
    }

    public Object[] toArray() {
        return this.values;
    }

    public List<TupleElement<?>> getElements() {
        return this.factory.getElements();
    }

    public void put(Integer key, Object value) {
        this.values[key.intValue()] = value;
    }

    <X> X assertAndConvertType(String id, Object value, Class<X> type) {
        try {
            if (type == null || value == null) {
                return (X)value;
            }
            return (X)Filters.convert(value, type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(_loc.get("tuple-element-wrong-type", new Object[]{id, value, value.getClass().getName(), type.getName()}).getMessage());
        }
    }

    static {
        try {
            PUT = TupleImpl.class.getMethod("put", Integer.class, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

