/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.PessimisticLockScope;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.metamodel.Metamodel;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.kernel.DelegatingBroker;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.AutoClearType;
import org.apache.openjpa.persistence.AutoDetachType;
import org.apache.openjpa.persistence.CallbackMode;
import org.apache.openjpa.persistence.ConnectionRetainMode;
import org.apache.openjpa.persistence.DetachStateType;
import org.apache.openjpa.persistence.EntityManagerFactoryImpl;
import org.apache.openjpa.persistence.Extent;
import org.apache.openjpa.persistence.ExtentImpl;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.Generator;
import org.apache.openjpa.persistence.GeneratorImpl;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.JPAProperties;
import org.apache.openjpa.persistence.MixedLockLevelsHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.OpenJPAEntityTransaction;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.PersistenceException;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.RestoreStateType;
import org.apache.openjpa.persistence.RollbackException;
import org.apache.openjpa.persistence.TransactionRequiredException;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaBuilder;
import org.apache.openjpa.persistence.criteria.OpenJPACriteriaQuery;
import org.apache.openjpa.persistence.query.QueryDefinition;
import org.apache.openjpa.persistence.validation.ValidationUtils;
import org.apache.openjpa.util.ExceptionInfo;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class EntityManagerImpl
implements OpenJPAEntityManagerSPI,
Externalizable,
FindCallbacks,
OpCallbacks,
Closeable,
OpenJPAEntityTransaction {
    private static final Localizer _loc = Localizer.forPackage(EntityManagerImpl.class);
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final String GET_LOCK_MODE = "getLockMode";
    private static final String LOCK = "lock";
    private static final String REFRESH = "refresh";
    private DelegatingBroker _broker;
    private EntityManagerFactoryImpl _emf;
    private Map<FetchConfiguration, FetchPlan> _plans = new IdentityHashMap<FetchConfiguration, FetchPlan>(1);
    protected RuntimeExceptionTranslator _ret = PersistenceExceptions.getRollbackTranslator(this);
    private boolean _convertPositionalParams = false;

    public EntityManagerImpl() {
    }

    public EntityManagerImpl(EntityManagerFactoryImpl factory, Broker broker) {
        this.initialize(factory, broker);
    }

    private void initialize(EntityManagerFactoryImpl factory, Broker broker) {
        this._emf = factory;
        this._broker = new DelegatingBroker(broker, this._ret);
        this._broker.setImplicitBehavior(this, this._ret);
        this._broker.putUserObject("org.apache.openjpa.persistence.EntityManager", this);
        this._convertPositionalParams = factory.getConfiguration().getCompatibilityInstance().getConvertPositionalParametersToNamed();
    }

    public Broker getBroker() {
        return this._broker.getDelegate();
    }

    @Override
    public OpenJPAEntityManagerFactory getEntityManagerFactory() {
        return this._emf;
    }

    @Override
    public OpenJPAConfiguration getConfiguration() {
        return this._broker.getConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchPlan getFetchPlan() {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            FetchConfiguration fc = this._broker.getFetchConfiguration();
            FetchPlan fp = this._plans.get(fc);
            if (fp == null) {
                fp = this._emf.toFetchPlan(this._broker, fc);
                this._plans.put(fc, fp);
            }
            FetchPlan fetchPlan = fp;
            return fetchPlan;
        }
        finally {
            this._broker.unlock();
        }
    }

    @Override
    public FetchPlan pushFetchPlan() {
        return this.pushFetchPlan(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FetchPlan pushFetchPlan(FetchConfiguration fc) {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            this._broker.pushFetchConfiguration(fc);
            FetchPlan fetchPlan = this.getFetchPlan();
            return fetchPlan;
        }
        finally {
            this._broker.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popFetchPlan() {
        this.assertNotCloseInvoked();
        this._broker.lock();
        try {
            this._plans.remove(this._broker.getFetchConfiguration());
            this._broker.popFetchConfiguration();
        }
        finally {
            this._broker.unlock();
        }
    }

    @Override
    public ConnectionRetainMode getConnectionRetainMode() {
        return ConnectionRetainMode.fromKernelConstant(this._broker.getConnectionRetainMode());
    }

    @Override
    public boolean isTransactionManaged() {
        return this._broker.isManaged();
    }

    @Override
    public boolean isManaged() {
        return this._broker.isManaged();
    }

    @Override
    public ManagedRuntime getManagedRuntime() {
        return this._broker.getManagedRuntime();
    }

    @Override
    public boolean getSyncWithManagedTransactions() {
        return this._broker.getSyncWithManagedTransactions();
    }

    @Override
    public void setSyncWithManagedTransactions(boolean sync) {
        this.assertNotCloseInvoked();
        this._broker.setSyncWithManagedTransactions(sync);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._broker.getClassLoader();
    }

    @Override
    public String getConnectionUserName() {
        return this._broker.getConnectionUserName();
    }

    @Override
    public String getConnectionPassword() {
        return this._broker.getConnectionPassword();
    }

    @Override
    public boolean getMultithreaded() {
        return this._broker.getMultithreaded();
    }

    @Override
    public void setMultithreaded(boolean multithreaded) {
        this.assertNotCloseInvoked();
        this._broker.setMultithreaded(multithreaded);
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._broker.getIgnoreChanges();
    }

    @Override
    public void setIgnoreChanges(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setIgnoreChanges(val);
    }

    @Override
    public boolean getNontransactionalRead() {
        return this._broker.getNontransactionalRead();
    }

    @Override
    public void setNontransactionalRead(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setNontransactionalRead(val);
    }

    @Override
    public boolean getNontransactionalWrite() {
        return this._broker.getNontransactionalWrite();
    }

    @Override
    public void setNontransactionalWrite(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setNontransactionalWrite(val);
    }

    @Override
    public boolean getOptimistic() {
        return this._broker.getOptimistic();
    }

    @Override
    public void setOptimistic(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setOptimistic(val);
    }

    @Override
    public RestoreStateType getRestoreState() {
        return RestoreStateType.fromKernelConstant(this._broker.getRestoreState());
    }

    @Override
    public void setRestoreState(RestoreStateType val) {
        this.assertNotCloseInvoked();
        this._broker.setRestoreState(val.toKernelConstant());
    }

    @Override
    public void setRestoreState(int restore) {
        this.assertNotCloseInvoked();
        this._broker.setRestoreState(restore);
    }

    @Override
    public boolean getRetainState() {
        return this._broker.getRetainState();
    }

    @Override
    public void setRetainState(boolean val) {
        this.assertNotCloseInvoked();
        this._broker.setRetainState(val);
    }

    @Override
    public AutoClearType getAutoClear() {
        return AutoClearType.fromKernelConstant(this._broker.getAutoClear());
    }

    @Override
    public void setAutoClear(AutoClearType val) {
        this.assertNotCloseInvoked();
        this._broker.setAutoClear(val.toKernelConstant());
    }

    @Override
    public void setAutoClear(int autoClear) {
        this.assertNotCloseInvoked();
        this._broker.setAutoClear(autoClear);
    }

    @Override
    public DetachStateType getDetachState() {
        return DetachStateType.fromKernelConstant(this._broker.getDetachState());
    }

    @Override
    public void setDetachState(DetachStateType type) {
        this.assertNotCloseInvoked();
        this._broker.setDetachState(type.toKernelConstant());
    }

    @Override
    public void setDetachState(int detach) {
        this.assertNotCloseInvoked();
        this._broker.setDetachState(detach);
    }

    @Override
    public EnumSet<AutoDetachType> getAutoDetach() {
        return AutoDetachType.toEnumSet(this._broker.getAutoDetach());
    }

    @Override
    public void setAutoDetach(AutoDetachType flag) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(EnumSet.of(flag)));
    }

    @Override
    public void setAutoDetach(EnumSet<AutoDetachType> flags) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(flags));
    }

    @Override
    public void setAutoDetach(int autoDetachFlags) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(autoDetachFlags);
    }

    @Override
    public void setAutoDetach(AutoDetachType value, boolean on) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(AutoDetachType.fromEnumSet(EnumSet.of(value)), on);
    }

    @Override
    public void setAutoDetach(int flag, boolean on) {
        this.assertNotCloseInvoked();
        this._broker.setAutoDetach(flag, on);
    }

    @Override
    public boolean getEvictFromStoreCache() {
        return this._broker.getEvictFromDataCache();
    }

    @Override
    public void setEvictFromStoreCache(boolean evict) {
        this.assertNotCloseInvoked();
        this._broker.setEvictFromDataCache(evict);
    }

    @Override
    public boolean getPopulateStoreCache() {
        return this._broker.getPopulateDataCache();
    }

    @Override
    public void setPopulateStoreCache(boolean cache) {
        this.assertNotCloseInvoked();
        this._broker.setPopulateDataCache(cache);
    }

    @Override
    public boolean isTrackChangesByType() {
        return this._broker.isTrackChangesByType();
    }

    @Override
    public void setTrackChangesByType(boolean trackByType) {
        this.assertNotCloseInvoked();
        this._broker.setTrackChangesByType(trackByType);
    }

    @Override
    public boolean isLargeTransaction() {
        return this.isTrackChangesByType();
    }

    @Override
    public void setLargeTransaction(boolean value) {
        this.setTrackChangesByType(value);
    }

    @Override
    public Object getUserObject(Object key) {
        return this._broker.getUserObject(key);
    }

    @Override
    public Object putUserObject(Object key, Object val) {
        this.assertNotCloseInvoked();
        return this._broker.putUserObject(key, val);
    }

    @Override
    public void addTransactionListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.addTransactionListener(listener);
    }

    @Override
    public void removeTransactionListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.removeTransactionListener(listener);
    }

    @Override
    public EnumSet<CallbackMode> getTransactionListenerCallbackModes() {
        return CallbackMode.toEnumSet(this._broker.getTransactionListenerCallbackMode());
    }

    @Override
    public void setTransactionListenerCallbackMode(CallbackMode mode) {
        this.assertNotCloseInvoked();
        this._broker.setTransactionListenerCallbackMode(CallbackMode.fromEnumSet(EnumSet.of(mode)));
    }

    @Override
    public void setTransactionListenerCallbackMode(EnumSet<CallbackMode> modes) {
        this.assertNotCloseInvoked();
        this._broker.setTransactionListenerCallbackMode(CallbackMode.fromEnumSet(modes));
    }

    @Override
    public int getTransactionListenerCallbackMode() {
        return this._broker.getTransactionListenerCallbackMode();
    }

    @Override
    public void setTransactionListenerCallbackMode(int callbackMode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLifecycleListener(Object listener, Class ... classes) {
        this.assertNotCloseInvoked();
        this._broker.addLifecycleListener(listener, classes);
    }

    @Override
    public void removeLifecycleListener(Object listener) {
        this.assertNotCloseInvoked();
        this._broker.removeLifecycleListener(listener);
    }

    @Override
    public EnumSet<CallbackMode> getLifecycleListenerCallbackModes() {
        return CallbackMode.toEnumSet(this._broker.getLifecycleListenerCallbackMode());
    }

    @Override
    public void setLifecycleListenerCallbackMode(CallbackMode mode) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(CallbackMode.fromEnumSet(EnumSet.of(mode)));
    }

    @Override
    public void setLifecycleListenerCallbackMode(EnumSet<CallbackMode> modes) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(CallbackMode.fromEnumSet(modes));
    }

    @Override
    public int getLifecycleListenerCallbackMode() {
        return this._broker.getLifecycleListenerCallbackMode();
    }

    @Override
    public void setLifecycleListenerCallbackMode(int callbackMode) {
        this.assertNotCloseInvoked();
        this._broker.setLifecycleListenerCallbackMode(callbackMode);
    }

    public <T> T getReference(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        oid = this._broker.newObjectId((Class)cls, oid);
        return (T)this._broker.find(oid, false, this);
    }

    public <T> T find(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        if (oid == null) {
            return null;
        }
        oid = this._broker.newObjectId((Class)cls, oid);
        return (T)this._broker.find(oid, true, this);
    }

    public <T> T find(Class<T> cls, Object oid, LockModeType mode) {
        return this.find(cls, oid, mode, null);
    }

    public <T> T find(Class<T> cls, Object oid, Map<String, Object> properties) {
        return this.find(cls, oid, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> cls, Object oid, LockModeType mode, Map<String, Object> properties) {
        this.assertNotCloseInvoked();
        properties = this.cloneProperties(properties);
        this.configureCurrentCacheModes(this.pushFetchPlan(), properties);
        this.configureCurrentFetchPlan(this.getFetchPlan(), properties, mode, true);
        try {
            oid = this._broker.newObjectId((Class)cls, oid);
            Object object = this._broker.find(oid, true, this);
            return (T)object;
        }
        finally {
            this.popFetchPlan();
        }
    }

    @Override
    public <T> T[] findAll(Class<T> cls, Object ... oids) {
        if (oids.length == 0) {
            return (Object[])Array.newInstance(cls, 0);
        }
        Collection<Object> ret = this.findAll(cls, Arrays.asList(oids));
        return ret.toArray((Object[])Array.newInstance(cls, ret.size()));
    }

    @Override
    public <T> Collection<T> findAll(final Class<T> cls, Collection oids) {
        this.assertNotCloseInvoked();
        Object[] objs = this._broker.findAll(oids, true, new FindCallbacks(){

            @Override
            public Object processArgument(Object oid) {
                return EntityManagerImpl.this._broker.newObjectId(cls, oid);
            }

            @Override
            public Object processReturn(Object oid, OpenJPAStateManager sm) {
                return EntityManagerImpl.this.processReturn(oid, sm);
            }
        });
        return Arrays.asList(objs);
    }

    @Override
    public <T> T findCached(Class<T> cls, Object oid) {
        this.assertNotCloseInvoked();
        return (T)this._broker.findCached(this._broker.newObjectId((Class)cls, oid), this);
    }

    @Override
    public Class getObjectIdClass(Class cls) {
        this.assertNotCloseInvoked();
        if (cls == null) {
            return null;
        }
        return JPAFacadeHelper.fromOpenJPAObjectIdClass(this._broker.getObjectIdType(cls));
    }

    @Override
    public OpenJPAEntityTransaction getTransaction() {
        if (this._broker.isManaged()) {
            throw new InvalidStateException(_loc.get("get-managed-trans"), null, null, false);
        }
        return this;
    }

    public void joinTransaction() {
        this.assertNotCloseInvoked();
        if (!this._broker.syncWithManagedTransaction()) {
            throw new TransactionRequiredException(_loc.get("no-managed-trans"), null, null, false);
        }
    }

    @Override
    public void begin() {
        this._broker.begin();
    }

    @Override
    public void commit() {
        try {
            this._broker.commit();
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (Exception e) {
            if (ValidationUtils.isConstraintViolationException(e)) {
                throw (RuntimeException)e;
            }
            Object failedObject = null;
            if (e instanceof ExceptionInfo) {
                failedObject = ((ExceptionInfo)((Object)e)).getFailedObject();
            }
            throw new RollbackException(e).setFailedObject(failedObject);
        }
    }

    @Override
    public void rollback() {
        this._broker.rollback();
    }

    @Override
    public void commitAndResume() {
        this._broker.commitAndResume();
    }

    @Override
    public void rollbackAndResume() {
        this._broker.rollbackAndResume();
    }

    @Override
    public Throwable getRollbackCause() {
        if (!this.isActive()) {
            throw new IllegalStateException(_loc.get("no-transaction").getMessage());
        }
        return this._broker.getRollbackCause();
    }

    @Override
    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(_loc.get("no-transaction").getMessage());
        }
        return this._broker.getRollbackOnly();
    }

    @Override
    public void setRollbackOnly() {
        this._broker.setRollbackOnly();
    }

    @Override
    public void setRollbackOnly(Throwable cause) {
        this._broker.setRollbackOnly(cause);
    }

    @Override
    public void setSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.setSavepoint(name);
    }

    @Override
    public void rollbackToSavepoint() {
        this.assertNotCloseInvoked();
        this._broker.rollbackToSavepoint();
    }

    @Override
    public void rollbackToSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.rollbackToSavepoint(name);
    }

    @Override
    public void releaseSavepoint() {
        this.assertNotCloseInvoked();
        this._broker.releaseSavepoint();
    }

    @Override
    public void releaseSavepoint(String name) {
        this.assertNotCloseInvoked();
        this._broker.releaseSavepoint(name);
    }

    public void flush() {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        this._broker.assertActiveTransaction();
        this._broker.flush();
    }

    @Override
    public void preFlush() {
        this.assertNotCloseInvoked();
        this._broker.preFlush();
    }

    @Override
    public void validateChanges() {
        this.assertNotCloseInvoked();
        this._broker.validateChanges();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this._broker.isActive();
    }

    @Override
    public boolean isStoreActive() {
        return this._broker.isStoreActive();
    }

    @Override
    public void beginStore() {
        this._broker.beginStore();
    }

    public boolean contains(Object entity) {
        this.assertNotCloseInvoked();
        if (entity == null) {
            return false;
        }
        OpenJPAStateManager sm = this._broker.getStateManager(entity);
        if (sm == null && !ImplHelper.isManagedType(this.getConfiguration(), entity.getClass())) {
            throw new ArgumentException(_loc.get("not-entity", entity.getClass()), null, null, true);
        }
        return sm != null && !sm.isDeleted();
    }

    @Override
    public boolean containsAll(Object ... entities) {
        for (Object entity : entities) {
            if (this.contains(entity)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection entities) {
        for (Object entity : entities) {
            if (this.contains(entity)) continue;
            return false;
        }
        return true;
    }

    public void persist(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.persist(entity, this);
    }

    @Override
    public void persistAll(Object ... entities) {
        this.persistAll(Arrays.asList(entities));
    }

    @Override
    public void persistAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.persistAll(entities, this);
    }

    public void remove(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.delete(entity, this);
    }

    @Override
    public void removeAll(Object ... entities) {
        this.removeAll(Arrays.asList(entities));
    }

    @Override
    public void removeAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.deleteAll(entities, this);
    }

    @Override
    public void release(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.release(entity, this);
    }

    @Override
    public void releaseAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.releaseAll(entities, this);
    }

    @Override
    public void releaseAll(Object ... entities) {
        this.releaseAll(Arrays.asList(entities));
    }

    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    public void refresh(Object entity, LockModeType mode) {
        this.refresh(entity, mode, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType mode, Map<String, Object> properties) {
        this.assertNotCloseInvoked();
        this.assertValidAttchedEntity(REFRESH, entity);
        this._broker.assertWriteOperation();
        this.configureCurrentCacheModes(this.pushFetchPlan(), properties);
        this.configureCurrentFetchPlan(this.getFetchPlan(), properties, mode, true);
        DataCacheRetrieveMode rmode = this.getFetchPlan().getCacheRetrieveMode();
        if (DataCacheRetrieveMode.USE.equals((Object)rmode) || rmode == null) {
            this.getFetchPlan().setCacheRetrieveMode(DataCacheRetrieveMode.BYPASS);
        }
        try {
            this._broker.refresh(entity, this);
        }
        finally {
            this.popFetchPlan();
        }
    }

    @Override
    public void refreshAll() {
        this.assertNotCloseInvoked();
        this._broker.assertWriteOperation();
        this._broker.refreshAll(this._broker.getTransactionalObjects(), this);
    }

    @Override
    public void refreshAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.assertWriteOperation();
        this._broker.refreshAll(entities, this);
    }

    @Override
    public void refreshAll(Object ... entities) {
        this.refreshAll(Arrays.asList(entities));
    }

    @Override
    public void retrieve(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.retrieve(entity, true, this);
    }

    @Override
    public void retrieveAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.retrieveAll(entities, true, (OpCallbacks)this);
    }

    @Override
    public void retrieveAll(Object ... entities) {
        this.retrieveAll(Arrays.asList(entities));
    }

    @Override
    public void evict(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.evict(entity, this);
    }

    @Override
    public void evictAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(entities, (OpCallbacks)this);
    }

    @Override
    public void evictAll(Object ... entities) {
        this.evictAll(Arrays.asList(entities));
    }

    @Override
    public void evictAll() {
        this.assertNotCloseInvoked();
        this._broker.evictAll(this);
    }

    @Override
    public void evictAll(Class cls) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(this._broker.newExtent(cls, true), (OpCallbacks)this);
    }

    @Override
    public void evictAll(Extent extent) {
        this.assertNotCloseInvoked();
        this._broker.evictAll(((ExtentImpl)extent).getDelegate(), (OpCallbacks)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T detachCopy(T entity) {
        this.assertNotCloseInvoked();
        Compatibility compat = this.getConfiguration().getCompatibilityInstance();
        boolean copyOnDetach = compat.getCopyOnDetach();
        boolean cascadeWithDetach = compat.getCascadeWithDetach();
        compat.setCopyOnDetach(true);
        compat.setCascadeWithDetach(true);
        try {
            Object t;
            Object object = t = this._broker.detach(entity, this);
            return (T)object;
        }
        finally {
            compat.setCopyOnDetach(copyOnDetach);
            compat.setCascadeWithDetach(cascadeWithDetach);
        }
    }

    @Override
    public Object[] detachAll(Object ... entities) {
        this.assertNotCloseInvoked();
        return this._broker.detachAll(Arrays.asList(entities), this);
    }

    @Override
    public Collection detachAll(Collection entities) {
        this.assertNotCloseInvoked();
        return Arrays.asList(this._broker.detachAll(entities, this));
    }

    public <T> T merge(T entity) {
        this.assertNotCloseInvoked();
        return (T)this._broker.attach(entity, true, this);
    }

    @Override
    public Object[] mergeAll(Object ... entities) {
        if (entities.length == 0) {
            return EMPTY_OBJECTS;
        }
        return this.mergeAll(Arrays.asList(entities)).toArray();
    }

    @Override
    public Collection mergeAll(Collection entities) {
        this.assertNotCloseInvoked();
        return Arrays.asList(this._broker.attachAll(entities, true, this));
    }

    @Override
    public void transactional(Object entity, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactional(entity, updateVersion, this);
    }

    @Override
    public void transactionalAll(Collection objs, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactionalAll(objs, updateVersion, (OpCallbacks)this);
    }

    @Override
    public void transactionalAll(Object[] objs, boolean updateVersion) {
        this.assertNotCloseInvoked();
        this._broker.transactionalAll(Arrays.asList(objs), updateVersion, (OpCallbacks)this);
    }

    @Override
    public void nontransactional(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.nontransactional(entity, this);
    }

    @Override
    public void nontransactionalAll(Collection objs) {
        this.assertNotCloseInvoked();
        this._broker.nontransactionalAll(objs, (OpCallbacks)this);
    }

    @Override
    public void nontransactionalAll(Object[] objs) {
        this.assertNotCloseInvoked();
        this._broker.nontransactionalAll(Arrays.asList(objs), (OpCallbacks)this);
    }

    @Override
    public Generator getNamedGenerator(String name) {
        this.assertNotCloseInvoked();
        try {
            SequenceMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getSequenceMetaData(name, this._broker.getClassLoader(), true);
            Seq seq = meta.getInstance(this._broker.getClassLoader());
            return new GeneratorImpl(seq, name, this._broker, null);
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    @Override
    public Generator getIdGenerator(Class forClass) {
        this.assertNotCloseInvoked();
        try {
            ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(forClass, this._broker.getClassLoader(), true);
            Seq seq = this._broker.getIdentitySequence(meta);
            return seq == null ? null : new GeneratorImpl(seq, null, this._broker, meta);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public Generator getFieldGenerator(Class forClass, String fieldName) {
        this.assertNotCloseInvoked();
        try {
            ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(forClass, this._broker.getClassLoader(), true);
            FieldMetaData fmd = meta.getField(fieldName);
            if (fmd == null) {
                throw new ArgumentException(_loc.get("no-named-field", forClass, fieldName), null, null, false);
            }
            Seq seq = this._broker.getValueSequence(fmd);
            return seq == null ? null : new GeneratorImpl(seq, null, this._broker, meta);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public <T> Extent<T> createExtent(Class<T> cls, boolean subclasses) {
        this.assertNotCloseInvoked();
        return new ExtentImpl(this, this._broker.newExtent(cls, subclasses));
    }

    public <T> TypedQuery<T> createQuery(String query, Class<T> resultClass) {
        return this.createQuery(query).setResultClass(resultClass);
    }

    @Override
    public OpenJPAQuery createQuery(String query) {
        return this.createQuery("javax.persistence.JPQL", query);
    }

    @Override
    public OpenJPAQuery createQuery(String language, String query) {
        this.assertNotCloseInvoked();
        try {
            Query q;
            if (query != null && this._convertPositionalParams && "javax.persistence.JPQL".equals(language)) {
                query = query.replaceAll("[\\?]", "\\:_");
            }
            String qid = query;
            PreparedQuery pq = "javax.persistence.JPQL".equals(language) ? this.getPreparedQuery(qid) : null;
            Query query2 = q = pq == null || !pq.isInitialized() ? this._broker.newQuery(language, query) : this._broker.newQuery(pq.getLanguage(), pq);
            if (pq == null && "javax.persistence.JPQL".equals(language)) {
                q.compile();
            }
            if (pq != null) {
                pq.setInto(q);
            }
            return this.newQueryImpl(q, null).setId(qid);
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    @Override
    public OpenJPAQuery createQuery(javax.persistence.Query query) {
        if (query == null) {
            return this.createQuery((String)null);
        }
        this.assertNotCloseInvoked();
        Query q = ((QueryImpl)query).getDelegate();
        return this.newQueryImpl(this._broker.newQuery(q.getLanguage(), q), null);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.createNamedQuery(name).setResultClass(resultClass);
    }

    @Override
    public OpenJPAQuery createNamedQuery(String name) {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        try {
            Query del;
            QueryMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getQueryMetaData(null, name, this._broker.getClassLoader(), true);
            String qid = meta.getQueryString();
            PreparedQuery pq = "javax.persistence.JPQL".equals(meta.getLanguage()) ? this.getPreparedQuery(qid) : null;
            Query query = del = pq == null || !pq.isInitialized() ? this._broker.newQuery(meta.getLanguage(), meta.getQueryString()) : this._broker.newQuery(pq.getLanguage(), pq);
            if (pq != null) {
                pq.setInto(del);
            } else {
                meta.setInto(del);
                del.compile();
            }
            QueryImpl q = this.newQueryImpl(del, meta).setId(qid);
            String[] hints = meta.getHintKeys();
            Object[] values = meta.getHintValues();
            for (int i = 0; i < hints.length; ++i) {
                q.setHint(hints[i], values[i]);
            }
            return q;
        }
        catch (RuntimeException re) {
            throw PersistenceExceptions.toPersistenceException(re);
        }
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query) {
        this.validateSQL(query);
        return this.createQuery("openjpa.SQL", query);
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query, Class cls) {
        return this.createNativeQuery(query).setResultClass(cls);
    }

    @Override
    public OpenJPAQuery createNativeQuery(String query, String mappingName) {
        this.assertNotCloseInvoked();
        this.validateSQL(query);
        Query kernelQuery = this._broker.newQuery("openjpa.SQL", query);
        kernelQuery.setResultMapping(null, mappingName);
        return this.newQueryImpl(kernelQuery, null);
    }

    protected <T> QueryImpl<T> newQueryImpl(Query kernelQuery, QueryMetaData qmd) {
        return new QueryImpl(this, this._ret, kernelQuery, qmd);
    }

    protected <T> QueryImpl<T> newQueryImpl(Query kernelQuery) {
        return new QueryImpl(this, this._ret, kernelQuery, null);
    }

    protected void validateSQL(String query) {
        if (StringUtils.trimToNull((String)query) == null) {
            throw new ArgumentException(_loc.get("no-sql"), null, null, false);
        }
    }

    PreparedQueryCache getPreparedQueryCache() {
        return this._broker.getCachePreparedQuery() ? this.getConfiguration().getQuerySQLCacheInstance() : null;
    }

    PreparedQuery getPreparedQuery(String id) {
        PreparedQueryCache cache = this.getPreparedQueryCache();
        return cache == null ? null : cache.get(id);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        this._broker.getFetchConfiguration().setFlushBeforeQueries(EntityManagerImpl.toFlushBeforeQueries(flushMode));
    }

    public FlushModeType getFlushMode() {
        this.assertNotCloseInvoked();
        this._broker.assertOpen();
        return EntityManagerImpl.fromFlushBeforeQueries(this._broker.getFetchConfiguration().getFlushBeforeQueries());
    }

    static FlushModeType fromFlushBeforeQueries(int flush) {
        switch (flush) {
            case 0: {
                return FlushModeType.AUTO;
            }
            case 1: {
                return FlushModeType.COMMIT;
            }
        }
        return null;
    }

    static int toFlushBeforeQueries(FlushModeType flushMode) {
        if (flushMode == null) {
            return 2;
        }
        if (flushMode == FlushModeType.AUTO) {
            return 0;
        }
        if (flushMode == FlushModeType.COMMIT) {
            return 1;
        }
        throw new ArgumentException(flushMode.toString(), null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareForPooling() {
        this.assertNotCloseInvoked();
        this.clear();
        if (this.getConnectionRetainMode() != ConnectionRetainMode.ALWAYS) {
            this._broker.lock();
            try {
                this._broker.getStoreManager().close();
            }
            finally {
                this._broker.unlock();
            }
        }
    }

    public void clear() {
        this.assertNotCloseInvoked();
        this._broker.detachAll(this, false);
        this._plans.clear();
    }

    public Object getDelegate() {
        this._broker.assertOpen();
        this.assertNotCloseInvoked();
        return this;
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        this.assertNotCloseInvoked();
        this._broker.assertActiveTransaction();
        this.assertValidAttchedEntity(GET_LOCK_MODE, entity);
        return MixedLockLevelsHelper.fromLockLevel(this._broker.getLockLevel(entity));
    }

    public void lock(Object entity, LockModeType mode) {
        this.lock(entity, mode, -1);
    }

    @Override
    public void lock(Object entity) {
        this.assertNotCloseInvoked();
        this.assertValidAttchedEntity(LOCK, entity);
        this._broker.lock(entity, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Object entity, LockModeType mode, int timeout) {
        this.assertNotCloseInvoked();
        this.assertValidAttchedEntity(LOCK, entity);
        this.configureCurrentFetchPlan(this.pushFetchPlan(), null, mode, false);
        try {
            this._broker.lock(entity, MixedLockLevelsHelper.toLockLevel(mode), timeout, this);
        }
        finally {
            this.popFetchPlan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType mode, Map<String, Object> properties) {
        this.assertNotCloseInvoked();
        this.assertValidAttchedEntity(LOCK, entity);
        this._broker.assertActiveTransaction();
        properties = this.cloneProperties(properties);
        this.configureCurrentCacheModes(this.pushFetchPlan(), properties);
        this.configureCurrentFetchPlan(this.getFetchPlan(), properties, mode, false);
        try {
            this._broker.lock(entity, MixedLockLevelsHelper.toLockLevel(mode), this._broker.getFetchConfiguration().getLockTimeout(), this);
        }
        finally {
            this.popFetchPlan();
        }
    }

    @Override
    public void lockAll(Collection entities) {
        this.assertNotCloseInvoked();
        this._broker.lockAll(entities, this);
    }

    @Override
    public void lockAll(Collection entities, LockModeType mode, int timeout) {
        this.assertNotCloseInvoked();
        this._broker.lockAll(entities, MixedLockLevelsHelper.toLockLevel(mode), timeout, this);
    }

    @Override
    public void lockAll(Object ... entities) {
        this.lockAll(Arrays.asList(entities));
    }

    @Override
    public void lockAll(Object[] entities, LockModeType mode, int timeout) {
        this.lockAll(Arrays.asList(entities), mode, timeout);
    }

    @Override
    public boolean cancelAll() {
        return this._broker.cancelAll();
    }

    @Override
    public Object getConnection() {
        return this._broker.getConnection();
    }

    @Override
    public Collection getManagedObjects() {
        return this._broker.getManagedObjects();
    }

    @Override
    public Collection getTransactionalObjects() {
        return this._broker.getTransactionalObjects();
    }

    @Override
    public Collection getPendingTransactionalObjects() {
        return this._broker.getPendingTransactionalObjects();
    }

    @Override
    public Collection getDirtyObjects() {
        return this._broker.getDirtyObjects();
    }

    @Override
    public boolean getOrderDirtyObjects() {
        return this._broker.getOrderDirtyObjects();
    }

    @Override
    public void setOrderDirtyObjects(boolean order) {
        this.assertNotCloseInvoked();
        this._broker.setOrderDirtyObjects(order);
    }

    @Override
    public void dirtyClass(Class cls) {
        this.assertNotCloseInvoked();
        this._broker.dirtyType(cls);
    }

    @Override
    public Collection<Class> getPersistedClasses() {
        return this._broker.getPersistedTypes();
    }

    @Override
    public Collection<Class> getUpdatedClasses() {
        return this._broker.getUpdatedTypes();
    }

    @Override
    public Collection<Class> getRemovedClasses() {
        return this._broker.getDeletedTypes();
    }

    @Override
    public <T> T createInstance(Class<T> cls) {
        this.assertNotCloseInvoked();
        return (T)this._broker.newInstance(cls);
    }

    @Override
    public void close() {
        this.assertNotCloseInvoked();
        Log log = this._emf.getConfiguration().getLog("openjpa.Runtime");
        if (log.isTraceEnabled()) {
            log.trace(this + ".close() invoked.");
        }
        this._broker.close();
        this._plans.clear();
    }

    public boolean isOpen() {
        return !this._broker.isCloseInvoked();
    }

    @Override
    public void dirty(Object o, String field) {
        this.assertNotCloseInvoked();
        OpenJPAStateManager sm = this._broker.getStateManager(o);
        try {
            if (sm != null) {
                sm.dirty(field);
            }
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    @Override
    public Object getObjectId(Object o) {
        this.assertNotCloseInvoked();
        return JPAFacadeHelper.fromOpenJPAObjectId(this._broker.getObjectId(o));
    }

    @Override
    public boolean isDirty(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isDirty(o);
    }

    @Override
    public boolean isTransactional(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isTransactional(o);
    }

    @Override
    public boolean isPersistent(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isPersistent(o);
    }

    @Override
    public boolean isNewlyPersistent(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isNew(o);
    }

    @Override
    public boolean isRemoved(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.isDeleted(o);
    }

    @Override
    public boolean isDetached(Object entity) {
        this.assertNotCloseInvoked();
        return this._broker.isDetached(entity);
    }

    @Override
    public Object getVersion(Object o) {
        this.assertNotCloseInvoked();
        return this._broker.getVersion(o);
    }

    protected void assertNotCloseInvoked() {
        if (!this._broker.isClosed() && this._broker.isCloseInvoked()) {
            throw new InvalidStateException(_loc.get("close-invoked"), null, null, true);
        }
    }

    void assertValidAttchedEntity(String call, Object entity) {
        OpenJPAStateManager sm = this._broker.getStateManager(entity);
        if (sm == null || !sm.isPersistent() || sm.isDetached() || call.equals(REFRESH) && sm.isDeleted()) {
            throw new IllegalArgumentException(_loc.get("invalid_entity_argument", call, entity == null ? "null" : Exceptions.toString(entity)).getMessage());
        }
    }

    @Override
    public Object processArgument(Object arg) {
        return arg;
    }

    @Override
    public Object processReturn(Object oid, OpenJPAStateManager sm) {
        return sm == null || sm.isDeleted() ? null : sm.getManagedInstance();
    }

    @Override
    public int processArgument(int op, Object obj, OpenJPAStateManager sm) {
        switch (op) {
            case 1: {
                if (sm == null && !this._broker.isDetached(obj)) {
                    return 2;
                }
                if (sm != null && !sm.isDetached() && !sm.isPersistent()) {
                    return 2;
                }
                if (sm == null || !sm.isDeleted()) break;
                return 0;
            }
            case 6: {
                if (sm != null && sm.isDeleted()) {
                    throw new UserException(_loc.get("removed", Exceptions.toString(obj))).setFailedObject(obj);
                }
                if (sm == null || sm.isDetached()) break;
                return 2;
            }
            case 2: {
                if (sm != null) break;
                throw new UserException(_loc.get("not-managed", Exceptions.toString(obj))).setFailedObject(obj);
            }
            case 7: {
                if (sm != null && sm.isPersistent() && !sm.isDetached()) break;
                return 0;
            }
        }
        return 6;
    }

    public int hashCode() {
        return this._broker == null ? 0 : this._broker.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._broker == null) {
            return false;
        }
        return this._broker.equals(((EntityManagerImpl)other)._broker);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this._ret = PersistenceExceptions.getRollbackTranslator(this);
            Object factoryKey = in.readObject();
            AbstractBrokerFactory factory = AbstractBrokerFactory.getPooledFactoryForKey(factoryKey);
            byte[] brokerBytes = (byte[])in.readObject();
            BrokerBytesInputStream innerIn = new BrokerBytesInputStream(brokerBytes, factory.getConfiguration());
            Broker broker = (Broker)innerIn.readObject();
            EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)JPAFacadeHelper.toEntityManagerFactory(broker.getBrokerFactory());
            broker.putUserObject("org.apache.openjpa.persistence.EntityManager", this);
            this.initialize(emf, broker);
        }
        catch (RuntimeException re) {
            try {
                re = this._ret.translate(re);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            Object factoryKey = ((AbstractBrokerFactory)this._broker.getBrokerFactory()).getPoolKey();
            out.writeObject(factoryKey);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream innerOut = new ObjectOutputStream(baos);
            this._broker.getDelegate().putUserObject("org.apache.openjpa.persistence.EntityManager", null);
            innerOut.writeObject(this._broker.getDelegate());
            innerOut.flush();
            out.writeObject(baos.toByteArray());
        }
        catch (RuntimeException re) {
            try {
                re = this._ret.translate(re);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw re;
        }
    }

    public void detach(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException(_loc.get("null-detach").getMessage());
        }
        this.assertNotCloseInvoked();
        this._broker.detach(entity, this);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        ((OpenJPACriteriaQuery)criteriaQuery).compile();
        Query kernelQuery = this._broker.newQuery("javax.persistence.criteria", criteriaQuery);
        QueryImpl facadeQuery = this.newQueryImpl(kernelQuery, null).setId(criteriaQuery.toString());
        Set params = criteriaQuery.getParameters();
        for (ParameterExpression param : params) {
            facadeQuery.declareParameter(param, (Parameter<?>)param);
        }
        return facadeQuery;
    }

    @Override
    public OpenJPAQuery createDynamicQuery(QueryDefinition qdef) {
        String jpql = this._emf.getDynamicQueryBuilder().toJPQL(qdef);
        return this.createQuery(jpql);
    }

    public Map<String, Object> getProperties() {
        Map<String, Object> props = this._broker.getProperties();
        for (String s : this._broker.getSupportedProperties()) {
            String kernelKey = this.getBeanPropertyName(s);
            Method getter = Reflection.findGetter(this.getClass(), kernelKey, false);
            if (getter == null) continue;
            String userKey = JPAProperties.getUserName(kernelKey);
            Object kvalue = Reflection.get((Object)this, getter);
            props.put(userKey.equals(kernelKey) ? s : userKey, JPAProperties.convertToUserValue(userKey, kvalue));
        }
        FetchPlan fetch = this.getFetchPlan();
        Class<?> fetchType = fetch.getClass();
        Set<String> fProperties = Reflection.getBeanStylePropertyNames(fetchType);
        for (String s : fProperties) {
            String kernelKey = this.getBeanPropertyName(s);
            Method getter = Reflection.findGetter(fetchType, kernelKey, false);
            if (getter == null) continue;
            String userKey = JPAProperties.getUserName(kernelKey);
            Object kvalue = Reflection.get((Object)fetch, getter);
            props.put(userKey.equals(kernelKey) ? s : userKey, JPAProperties.convertToUserValue(userKey, kvalue));
        }
        return props;
    }

    @Override
    public OpenJPACriteriaBuilder getCriteriaBuilder() {
        return this._emf.getCriteriaBuilder();
    }

    @Override
    public Set<String> getSupportedProperties() {
        return this._broker.getSupportedProperties();
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls != null && cls != Object.class) {
            Object[] delegates;
            for (Object o : delegates = new Object[]{this._broker.getInnermostDelegate(), this._broker.getDelegate(), this._broker, this}) {
                if (!cls.isInstance(o)) continue;
                return (T)o;
            }
            if (cls.isAssignableFrom(Connection.class)) {
                Object o = this.getConnection();
                if (Connection.class.isInstance(o)) {
                    return (T)o;
                }
                ImplHelper.close(o);
            }
        }
        PersistenceException ex = new PersistenceException(_loc.get("unwrap-em-invalid", cls).toString(), null, this, false);
        if (this.isActive()) {
            this.setRollbackOnly((Throwable)((Object)ex));
        }
        throw ex;
    }

    @Override
    public void setQuerySQLCache(boolean flag) {
        this._broker.setCachePreparedQuery(flag);
    }

    @Override
    public boolean getQuerySQLCache() {
        return this._broker.getCachePreparedQuery();
    }

    RuntimeExceptionTranslator getExceptionTranslator() {
        return this._ret;
    }

    private void configureCurrentFetchPlan(FetchPlan fetch, Map<String, Object> properties, LockModeType lock, boolean requiresTxn) {
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (key.equals("javax.persistence.lock.scope")) {
                    fetch.setLockScope((PessimisticLockScope)value);
                    continue;
                }
                fetch.setHint(key, value);
            }
        }
        if (lock != null && lock != LockModeType.NONE) {
            LockModeType curReadLockMode;
            if (requiresTxn) {
                this._broker.assertActiveTransaction();
            }
            if (lock != (curReadLockMode = fetch.getReadLockMode())) {
                fetch.setReadLockMode(lock);
            }
        }
    }

    private void configureCurrentCacheModes(FetchPlan fetch, Map<String, Object> properties) {
        CacheStoreMode sMode;
        if (properties == null) {
            return;
        }
        CacheRetrieveMode rMode = JPAProperties.getEnumValue(CacheRetrieveMode.class, "javax.persistence.cache.retrieveMode", properties);
        if (rMode != null) {
            fetch.setCacheRetrieveMode(JPAProperties.convertToKernelValue(DataCacheRetrieveMode.class, "javax.persistence.cache.retrieveMode", rMode));
            properties.remove("javax.persistence.cache.retrieveMode");
        }
        if ((sMode = JPAProperties.getEnumValue(CacheStoreMode.class, "javax.persistence.cache.storeMode", properties)) != null) {
            fetch.setCacheStoreMode(JPAProperties.convertToKernelValue(DataCacheStoreMode.class, "javax.persistence.cache.storeMode", sMode));
            properties.remove("javax.persistence.cache.storeMode");
        }
    }

    public Metamodel getMetamodel() {
        return this._emf.getMetamodel();
    }

    public void setProperty(String prop, Object value) {
        Log log;
        if (!this.setKernelProperty(this, prop, value) && !this.setKernelProperty(this.getFetchPlan(), prop, value) && (log = this.getConfiguration().getLog("openjpa.Runtime")).isWarnEnabled()) {
            log.warn(_loc.get("ignored-em-prop", prop, value == null ? "" : value.getClass() + ":" + value));
        }
    }

    private boolean setKernelProperty(Object target, String original, Object value) {
        String beanProp = this.getBeanPropertyName(original);
        JPAProperties.record(beanProp, original);
        Class<?> kType = null;
        Object kValue = null;
        Method setter = Reflection.findSetter(target.getClass(), beanProp, false);
        if (setter != null) {
            kType = setter.getParameterTypes()[0];
            kValue = this.convertUserValue(original, value, kType);
            Reflection.set(target, setter, kValue);
            return true;
        }
        Field field = Reflection.findField(target.getClass(), beanProp, false);
        if (field != null) {
            kType = field.getType();
            kValue = this.convertUserValue(original, value, kType);
            Reflection.set(target, field, kValue);
            return true;
        }
        return false;
    }

    String getBeanPropertyName(String user) {
        String result = user;
        if (JPAProperties.isValidKey(user)) {
            result = JPAProperties.getBeanProperty(user);
        } else {
            int dot = user.lastIndexOf(46);
            if (dot != -1) {
                result = user.substring(dot + 1);
            }
        }
        return result;
    }

    Object convertUserValue(String key, Object value, Class<?> targetType) {
        if (JPAProperties.isValidKey(key)) {
            return JPAProperties.convertToKernelValue(targetType, key, value);
        }
        if (value instanceof String) {
            if ("null".equals(value)) {
                return null;
            }
            String val = (String)value;
            int parenIndex = val.indexOf(40);
            if (!String.class.equals(targetType) && parenIndex > 0) {
                val = val.substring(0, parenIndex);
            }
            return Strings.parse((String)val, targetType);
        }
        if (value instanceof AutoDetachType) {
            EnumSet<AutoDetachType> autoDetachFlags = EnumSet.noneOf(AutoDetachType.class);
            autoDetachFlags.add((AutoDetachType)((Object)value));
            return autoDetachFlags;
        }
        if (value instanceof AutoDetachType[]) {
            EnumSet<AutoDetachType> autoDetachFlags = EnumSet.noneOf(AutoDetachType.class);
            autoDetachFlags.addAll(Arrays.asList((AutoDetachType[])value));
            return autoDetachFlags;
        }
        return value;
    }

    private Map<String, Object> cloneProperties(Map<String, Object> properties) {
        if (properties != null) {
            properties = new HashMap<String, Object>(properties);
        }
        return properties;
    }

    private static class BrokerBytesInputStream
    extends ObjectInputStream {
        private OpenJPAConfiguration conf;

        BrokerBytesInputStream(byte[] bytes, OpenJPAConfiguration conf) throws IOException {
            super(new ByteArrayInputStream(bytes));
            if (conf == null) {
                throw new IllegalArgumentException("Illegal null argument to ObjectInputStreamWithLoader");
            }
            this.conf = conf;
        }

        private Class primitiveType(char type) {
            switch (type) {
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            return null;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String cname = classDesc.getName();
            if (cname.startsWith("[")) {
                Class component;
                int dcount = 1;
                while (cname.charAt(dcount) == '[') {
                    ++dcount;
                }
                if (cname.charAt(dcount) == 'L') {
                    component = this.lookupClass(cname.substring(dcount + 1, cname.length() - 1));
                } else {
                    if (cname.length() != dcount + 1) {
                        throw new ClassNotFoundException(cname);
                    }
                    component = this.primitiveType(cname.charAt(dcount));
                }
                int[] dim = new int[dcount];
                for (int i = 0; i < dcount; ++i) {
                    dim[i] = 0;
                }
                return Array.newInstance(component, dim).getClass();
            }
            return this.lookupClass(cname);
        }

        private Class<?> lookupClass(String className) throws ClassNotFoundException {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (PCEnhancer.isPCSubclassName(className)) {
                    String superName = PCEnhancer.toManagedTypeName(className);
                    ClassMetaData[] metas = this.conf.getMetaDataRepositoryInstance().getMetaDatas();
                    for (int i = 0; i < metas.length; ++i) {
                        if (!superName.equals(metas[i].getDescribedType().getName())) continue;
                        return PCRegistry.getPCType(metas[i].getDescribedType());
                    }
                    return Class.forName(className);
                }
                throw e;
            }
        }
    }
}

