/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.util.InternalException;

class CurrentDate
extends Const {
    private final Class<? extends Date> _type;

    public CurrentDate(Class<? extends Date> type) {
        this._type = type;
    }

    @Override
    public Class<? extends Date> getType() {
        return this._type;
    }

    @Override
    public void setImplicitType(Class type) {
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        if (Timestamp.class.isAssignableFrom(this._type)) {
            return res.getTimestamp(this, null);
        }
        if (Time.class.isAssignableFrom(this._type)) {
            return res.getTime(this, null);
        }
        if (Date.class.isAssignableFrom(this._type)) {
            return res.getDate(this, null);
        }
        throw new InternalException();
    }

    @Override
    public Object getValue(Object[] params) {
        try {
            return this._type.getConstructor(Long.TYPE).newInstance(System.currentTimeMillis());
        }
        catch (Exception e) {
            return new Date();
        }
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        if (Timestamp.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentTimestampFunction);
        } else if (Time.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentTimeFunction);
        } else if (Date.class.isAssignableFrom(this._type)) {
            sql2.append(ctx.store.getDBDictionary().currentDateFunction);
        } else {
            throw new InternalException();
        }
    }
}

