/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionContext;
import org.apache.myfaces.test.mock.MockEnumeration;

public class MockHttpSession
implements HttpSession {
    private List attributeListeners = new ArrayList();
    private HashMap attributes = new HashMap();
    private String id = "123";
    private ServletContext servletContext = null;
    private boolean invalid = false;

    public MockHttpSession() {
    }

    public MockHttpSession(ServletContext servletContext) {
        this.setServletContext(servletContext);
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        this.attributeListeners.add(listener);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object getAttribute(String name) {
        this.assertValidity();
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        this.assertValidity();
        return new MockEnumeration(this.attributes.keySet().iterator());
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        throw new UnsupportedOperationException();
    }

    public int getMaxInactiveInterval() {
        throw new UnsupportedOperationException();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException();
    }

    public Object getValue(String name) {
        throw new UnsupportedOperationException();
    }

    public String[] getValueNames() {
        throw new UnsupportedOperationException();
    }

    public void invalidate() {
        this.assertValidity();
        this.attributes.clear();
        this.invalid = true;
    }

    public boolean isNew() {
        throw new UnsupportedOperationException();
    }

    public void putValue(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public void removeAttribute(String name) {
        this.assertValidity();
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void removeValue(String name) {
        throw new UnsupportedOperationException();
    }

    public void setAttribute(String name, Object value) {
        this.assertValidity();
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    public void setMaxInactiveInterval(int interval) {
        throw new UnsupportedOperationException();
    }

    private void fireAttributeAdded(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        for (HttpSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeAdded(event);
        }
    }

    private void fireAttributeRemoved(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        for (HttpSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeRemoved(event);
        }
    }

    private void fireAttributeReplaced(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
        for (HttpSessionAttributeListener listener : this.attributeListeners) {
            listener.attributeReplaced(event);
        }
    }

    private void assertValidity() {
        if (this.invalid) {
            throw new IllegalStateException("Session is invalid.");
        }
    }
}

