/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.wagon.TransferFailedException;

public class LSParser {
    private Pattern PATTERN = Pattern.compile(".+\\s+[0-9]+\\s+.+\\s+.+\\s+[0-9]+\\s+([0-9]{4}-[0-9]{2}-[0-9]{2}|.+\\s+[0-9]+)\\s+[0-9:]+\\s+(.+?)");

    public List parseFiles(String rawLS) throws TransferFailedException {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new StringReader(rawLS));
            String line = br.readLine();
            while (line != null) {
                Matcher m = this.PATTERN.matcher(line = line.trim());
                if (m.matches()) {
                    ret.add(m.group(2));
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Error parsing file listing.", (Throwable)e);
        }
        return ret;
    }
}

