/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.surefire.report.ClassNameStackTraceFilter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceFilter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartStackTraceParser {
    private static final int MAX_LINE_LENGTH = 77;
    private final SafeThrowable throwable;
    private final StackTraceElement[] stackTrace;
    private final String simpleName;
    private String testClassName;
    private final Class testClass;
    private String testMethodName;

    public SmartStackTraceParser(Class testClass, Throwable throwable) {
        this(testClass.getName(), throwable, null);
    }

    public SmartStackTraceParser(String testClassName, Throwable throwable, String testMethodName) {
        this.testMethodName = testMethodName;
        this.testClassName = testClassName;
        this.testClass = SmartStackTraceParser.getClass(testClassName);
        this.simpleName = testClassName.substring(testClassName.lastIndexOf(".") + 1);
        this.throwable = new SafeThrowable(throwable);
        this.stackTrace = throwable.getStackTrace();
    }

    private static Class getClass(String name) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader != null ? classLoader.loadClass(name) : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static String getSimpleName(String className) {
        int i = className.lastIndexOf(".");
        return className.substring(i + 1);
    }

    public String getString() {
        Throwable target;
        if (this.testClass == null) {
            return this.throwable.getLocalizedMessage();
        }
        StringBuilder result = new StringBuilder();
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusOnClass(this.stackTrace, this.testClass);
        Collections.reverse(stackTraceElements);
        if (stackTraceElements.isEmpty()) {
            result.append(this.simpleName);
            if (StringUtils.isNotEmpty(this.testMethodName)) {
                result.append(".").append(this.testMethodName);
            }
        } else {
            for (int i = 0; i < stackTraceElements.size(); ++i) {
                StackTraceElement stackTraceElement = stackTraceElements.get(i);
                if (i == 0) {
                    result.append(this.simpleName);
                    if (!stackTraceElement.getClassName().equals(this.testClassName)) {
                        result.append(">");
                    } else {
                        result.append(".");
                    }
                }
                if (!stackTraceElement.getClassName().equals(this.testClassName)) {
                    result.append(SmartStackTraceParser.getSimpleName(stackTraceElement.getClassName())).append(".");
                }
                result.append(stackTraceElement.getMethodName()).append(":").append(stackTraceElement.getLineNumber()).append("->");
            }
            if (result.length() >= 2) {
                result.deleteCharAt(result.length() - 1).deleteCharAt(result.length() - 1);
            }
        }
        if ((target = this.throwable.getTarget()) instanceof AssertionError) {
            result.append(" ").append(this.throwable.getMessage());
        } else if ("junit.framework.AssertionFailedError".equals(target.getClass().getName()) || "junit.framework.ComparisonFailure".equals(target.getClass().getName())) {
            result.append(" ");
            result.append(this.throwable.getMessage());
        } else {
            result.append(this.rootIsInclass() ? " " : " \u00bb ");
            result.append(this.getMinimalThrowableMiniMessage(target));
            result.append(this.getTruncatedMessage(77 - result.length()));
        }
        return result.toString();
    }

    private String getMinimalThrowableMiniMessage(Throwable throwable) {
        String name = throwable.getClass().getSimpleName();
        if (name.endsWith("Exception")) {
            return StringUtils.chompLast(name, "Exception");
        }
        if (name.endsWith("Error")) {
            return StringUtils.chompLast(name, "Error");
        }
        return name;
    }

    private String getTruncatedMessage(int i) {
        if (i < 0) {
            return "";
        }
        String msg = this.throwable.getMessage();
        if (msg == null) {
            return "";
        }
        String substring = msg.substring(0, Math.min(i, msg.length()));
        if (i < msg.length()) {
            return " " + substring + "...";
        }
        return " " + substring;
    }

    private boolean rootIsInclass() {
        return this.stackTrace.length > 0 && this.stackTrace[0].getClassName().equals(this.testClassName);
    }

    static List<StackTraceElement> focusOnClass(StackTraceElement[] stackTrace, Class clazz) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (element == null || !SmartStackTraceParser.isInSupers(clazz, element.getClassName())) continue;
            result.add(element);
        }
        return result;
    }

    private static boolean isInSupers(Class testClass, String lookFor) {
        if (lookFor.startsWith("junit.framework.")) {
            return false;
        }
        while (!testClass.getName().equals(lookFor) && testClass.getSuperclass() != null) {
            testClass = testClass.getSuperclass();
        }
        return testClass.getName().equals(lookFor);
    }

    static Throwable findTopmostWithClass(Throwable t, StackTraceFilter filter) {
        Throwable n = t;
        do {
            if (!SmartStackTraceParser.containsClassName(n.getStackTrace(), filter)) continue;
            return n;
        } while ((n = n.getCause()) != null);
        return t;
    }

    public static String stackTraceWithFocusOnClassAsString(Throwable t, String className) {
        ClassNameStackTraceFilter filter = new ClassNameStackTraceFilter(className);
        Throwable topmost = SmartStackTraceParser.findTopmostWithClass(t, filter);
        List<StackTraceElement> stackTraceElements = SmartStackTraceParser.focusInsideClass(topmost.getStackTrace(), filter);
        String s = SmartStackTraceParser.causeToString(topmost.getCause(), filter);
        return SmartStackTraceParser.toString(t, stackTraceElements, filter) + s;
    }

    static List<StackTraceElement> focusInsideClass(StackTraceElement[] stackTrace, StackTraceFilter filter) {
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (!filter.matches(element)) continue;
            result.add(element);
        }
        return result;
    }

    static boolean containsClassName(StackTraceElement[] stackTrace, StackTraceFilter filter) {
        for (StackTraceElement element : stackTrace) {
            if (!filter.matches(element)) continue;
            return true;
        }
        return false;
    }

    private static String causeToString(Throwable cause, StackTraceFilter filter) {
        String resp = "";
        while (cause != null) {
            resp = resp + "Caused by: ";
            resp = resp + SmartStackTraceParser.toString(cause, Arrays.asList(cause.getStackTrace()), filter);
            cause = cause.getCause();
        }
        return resp;
    }

    private static String toString(Throwable t, Iterable<StackTraceElement> elements, StackTraceFilter filter) {
        String result = "";
        if (t != null) {
            result = result + t.getClass().getName();
            String msg = t.getMessage();
            if (msg != null) {
                result = result + ": ";
                if (SmartStackTraceParser.isMultiLine(msg)) {
                    result = result + "\n";
                }
                result = result + msg;
            }
            result = result + "\n";
        }
        for (StackTraceElement element : elements) {
            if (!filter.matches(element)) continue;
            result = result + "\tat ";
            result = result + element;
            result = result + "\n";
        }
        return result;
    }

    private static boolean isMultiLine(String msg) {
        int countNewLines = 0;
        int length = msg.length();
        for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
        }
        return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
    }
}

