/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.ProviderFactory;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.suite.RunResult;

public class ForkedBooter {
    public static void main(String[] args) throws Throwable {
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            ClassLoader testClassLoader = classpathConfiguration.createForkingTestClassLoader(startupConfiguration.isManifestOnlyJarRequestedAndUsable());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue() : null;
            ForkedBooter.runSuitesInProcess(testSet, testClassLoader, startupConfiguration, providerConfiguration);
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static RunResult runSuitesInProcess(Object testSet, ClassLoader testsClassLoader, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration) throws SurefireExecutionException {
        ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
        ClassLoader surefireClassLoader = classpathConfiguration.createSurefireClassLoader(testsClassLoader);
        SurefireReflector surefireReflector = new SurefireReflector(surefireClassLoader);
        Object factory = ForkedBooter.createForkingReporterFactory(surefireReflector, providerConfiguration);
        return ProviderFactory.invokeProvider(testSet, testsClassLoader, surefireClassLoader, factory, providerConfiguration, true, startupConfiguration);
    }

    private static Object createForkingReporterFactory(SurefireReflector surefireReflector, ProviderConfiguration providerConfiguration) {
        Boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        PrintStream originalSystemOut = providerConfiguration.getReporterConfiguration().getOriginalSystemOut();
        return surefireReflector.createForkingReporterFactory(trimStackTrace, originalSystemOut);
    }
}

