/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.extensions.SurefireConsoleOutputReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessReporter;
import org.apache.maven.plugin.surefire.extensions.SurefireStatelessTestsetInfoReporter;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.ConsoleLoggerDecorator;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.api.util.ReflectionUtils;
import org.apache.maven.surefire.api.util.SurefireReflectionException;

public class CommonReflector {
    private final Class<?> startupReportConfiguration;
    private final Class<?> consoleLogger;
    private final Class<?> statelessTestsetReporter;
    private final Class<?> consoleOutputReporter;
    private final Class<?> statelessTestsetInfoReporter;
    private final ClassLoader surefireClassLoader;

    public CommonReflector(@Nonnull ClassLoader surefireClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        try {
            this.startupReportConfiguration = surefireClassLoader.loadClass(StartupReportConfiguration.class.getName());
            this.consoleLogger = surefireClassLoader.loadClass(ConsoleLogger.class.getName());
            this.statelessTestsetReporter = surefireClassLoader.loadClass(SurefireStatelessReporter.class.getName());
            this.consoleOutputReporter = surefireClassLoader.loadClass(SurefireConsoleOutputReporter.class.getName());
            this.statelessTestsetInfoReporter = surefireClassLoader.loadClass(SurefireStatelessTestsetInfoReporter.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException((Throwable)e);
        }
    }

    public Object createReportingReporterFactory(@Nonnull StartupReportConfiguration startupReportConfiguration, @Nonnull ConsoleLogger consoleLogger) {
        Class[] args = new Class[]{this.startupReportConfiguration, this.consoleLogger};
        Object src = this.createStartupReportConfiguration(startupReportConfiguration);
        Object logger = CommonReflector.createConsoleLogger(consoleLogger, this.surefireClassLoader);
        Object[] params = new Object[]{src, logger};
        return ReflectionUtils.instantiateObject((String)DefaultReporterFactory.class.getName(), (Class[])args, (Object[])params, (ClassLoader)this.surefireClassLoader);
    }

    private Object createStartupReportConfiguration(@Nonnull StartupReportConfiguration reporterConfiguration) {
        Constructor constructor = ReflectionUtils.getConstructor(this.startupReportConfiguration, (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, File.class, Boolean.TYPE, String.class, File.class, Boolean.TYPE, Integer.TYPE, String.class, String.class, Boolean.TYPE, this.statelessTestsetReporter, this.consoleOutputReporter, this.statelessTestsetInfoReporter});
        Object[] params = new Object[]{reporterConfiguration.isUseFile(), reporterConfiguration.isPrintSummary(), reporterConfiguration.getReportFormat(), reporterConfiguration.isRedirectTestOutputToFile(), reporterConfiguration.getReportsDirectory(), reporterConfiguration.isTrimStackTrace(), reporterConfiguration.getReportNameSuffix(), reporterConfiguration.getStatisticsFile(), reporterConfiguration.isRequiresRunHistory(), reporterConfiguration.getRerunFailingTestsCount(), reporterConfiguration.getXsdSchemaLocation(), reporterConfiguration.getEncoding().name(), reporterConfiguration.isForking(), reporterConfiguration.getXmlReporter().clone(this.surefireClassLoader), reporterConfiguration.getConsoleOutputReporter().clone(this.surefireClassLoader), reporterConfiguration.getTestsetReporter().clone(this.surefireClassLoader)};
        return ReflectionUtils.newInstance((Constructor)constructor, (Object[])params);
    }

    static Object createConsoleLogger(ConsoleLogger consoleLogger, ClassLoader cl) {
        try {
            Class<?> decoratorClass = cl.loadClass(ConsoleLoggerDecorator.class.getName());
            return ReflectionUtils.getConstructor(decoratorClass, (Class[])new Class[]{Object.class}).newInstance(consoleLogger);
        }
        catch (Exception e) {
            throw new SurefireReflectionException((Throwable)e);
        }
    }
}

