/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.shade.common.org.apache.maven.shared.utils.StringUtils;

final class TestClassPath {
    private final Iterable<Artifact> artifacts;
    private final File classesDirectory;
    private final File testClassesDirectory;
    private final String[] additionalClasspathElements;
    private final ConsoleLogger logger;

    TestClassPath(Iterable<Artifact> artifacts, File classesDirectory, File testClassesDirectory, String[] additionalClasspathElements, ConsoleLogger logger) {
        this.artifacts = artifacts;
        this.classesDirectory = classesDirectory;
        this.testClassesDirectory = testClassesDirectory;
        this.additionalClasspathElements = additionalClasspathElements;
        this.logger = logger;
    }

    void avoidArtifactDuplicates(Set<Artifact> providerArtifacts) {
        for (Artifact artifact : this.artifacts) {
            Iterator<Artifact> it = providerArtifacts.iterator();
            while (it.hasNext()) {
                Artifact providerArtifact = it.next();
                String classifier1 = providerArtifact.getClassifier();
                String classifier2 = artifact.getClassifier();
                if (!providerArtifact.getGroupId().equals(artifact.getGroupId()) || !providerArtifact.getArtifactId().equals(artifact.getArtifactId()) || !providerArtifact.getType().equals(artifact.getType()) || !(classifier1 == null ? classifier2 == null : classifier1.equals(classifier2))) continue;
                it.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Removed artifact " + providerArtifact + " from provider. Already appears in test classpath.");
            }
        }
    }

    Classpath toClasspath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.testClassesDirectory.getAbsolutePath());
        classpath.add(this.classesDirectory.getAbsolutePath());
        for (Artifact artifact : this.artifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getAbsolutePath());
        }
        if (this.additionalClasspathElements != null) {
            for (String additionalClasspathElement : this.additionalClasspathElements) {
                if (additionalClasspathElement == null) continue;
                Collections.addAll(classpath, StringUtils.split(additionalClasspathElement, ","));
            }
        }
        return new Classpath(classpath);
    }
}

