/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.TestProvidingInputStream;
import org.apache.maven.plugin.surefire.booterclient.output.DeserializedStacktraceWriter;
import org.apache.maven.plugin.surefire.report.DefaultReporterFactory;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ConsoleLogger;
import org.apache.maven.surefire.report.ConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.surefire.util.internal.StringUtils;

public class ForkClient
implements StreamConsumer {
    private final DefaultReporterFactory defaultReporterFactory;
    private final TestProvidingInputStream testProvidingInputStream;
    private final Map<Integer, RunListener> testSetReporters = Collections.synchronizedMap(new HashMap());
    private final Properties testVmSystemProperties;
    private volatile boolean saidGoodBye = false;
    private volatile StackTraceWriter errorInFork = null;

    public ForkClient(DefaultReporterFactory defaultReporterFactory, Properties testVmSystemProperties) {
        this(defaultReporterFactory, testVmSystemProperties, null);
    }

    public ForkClient(DefaultReporterFactory defaultReporterFactory, Properties testVmSystemProperties, TestProvidingInputStream testProvidingInputStream) {
        this.defaultReporterFactory = defaultReporterFactory;
        this.testVmSystemProperties = testVmSystemProperties;
        this.testProvidingInputStream = testProvidingInputStream;
    }

    public DefaultReporterFactory getDefaultReporterFactory() {
        return this.defaultReporterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeLine(String s) {
        try {
            if (s.length() == 0) {
                return;
            }
            byte operationId = (byte)s.charAt(0);
            int commma = s.indexOf(",", 3);
            if (commma < 0) {
                System.out.println(s);
                return;
            }
            Integer channelNumber = Integer.parseInt(s.substring(2, commma), 16);
            int rest = s.indexOf(",", commma);
            String remaining = s.substring(rest + 1);
            switch (operationId) {
                case 49: {
                    this.getOrCreateReporter(channelNumber).testSetStarting(this.createReportEntry(remaining));
                    break;
                }
                case 50: {
                    this.getOrCreateReporter(channelNumber).testSetCompleted(this.createReportEntry(remaining));
                    break;
                }
                case 53: {
                    this.getOrCreateReporter(channelNumber).testStarting(this.createReportEntry(remaining));
                    break;
                }
                case 54: {
                    this.getOrCreateReporter(channelNumber).testSucceeded(this.createReportEntry(remaining));
                    break;
                }
                case 56: {
                    this.getOrCreateReporter(channelNumber).testFailed(this.createReportEntry(remaining));
                    break;
                }
                case 57: {
                    this.getOrCreateReporter(channelNumber).testSkipped(this.createReportEntry(remaining));
                    break;
                }
                case 55: {
                    this.getOrCreateReporter(channelNumber).testError(this.createReportEntry(remaining));
                    break;
                }
                case 71: {
                    this.getOrCreateReporter(channelNumber).testAssumptionFailure(this.createReportEntry(remaining));
                    break;
                }
                case 73: {
                    int keyEnd = remaining.indexOf(",");
                    StringBuilder key = new StringBuilder();
                    StringBuilder value = new StringBuilder();
                    StringUtils.unescapeString((StringBuilder)key, (CharSequence)remaining.substring(0, keyEnd));
                    StringUtils.unescapeString((StringBuilder)value, (CharSequence)remaining.substring(keyEnd + 1));
                    Properties properties = this.testVmSystemProperties;
                    synchronized (properties) {
                        this.testVmSystemProperties.put(key.toString(), value.toString());
                        break;
                    }
                }
                case 51: {
                    byte[] bytes = new byte[remaining.length()];
                    int len = StringUtils.unescapeBytes((byte[])bytes, (String)remaining);
                    this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(bytes, 0, len, true);
                    break;
                }
                case 52: {
                    byte[] bytes = new byte[remaining.length()];
                    int len = StringUtils.unescapeBytes((byte[])bytes, (String)remaining);
                    this.getOrCreateConsoleOutputReceiver(channelNumber).writeTestOutput(bytes, 0, len, false);
                    break;
                }
                case 72: {
                    this.getOrCreateConsoleLogger(channelNumber).info(this.createConsoleMessage(remaining));
                    break;
                }
                case 78: {
                    if (null != this.testProvidingInputStream) {
                        this.testProvidingInputStream.provideNewTest();
                    }
                    break;
                }
                case 88: {
                    this.errorInFork = this.deserializeStackStraceWriter(new StringTokenizer(remaining, ","));
                    break;
                }
                case 90: {
                    this.saidGoodBye = true;
                    break;
                }
                default: {
                    System.out.println(s);
                }
            }
        }
        catch (NumberFormatException e) {
            System.out.println(s);
        }
        catch (ReporterException e) {
            throw new RuntimeException(e);
        }
    }

    public void consumeMultiLineContent(String s) throws IOException {
        String s1;
        BufferedReader stringReader = new BufferedReader(new StringReader(s));
        while ((s1 = stringReader.readLine()) != null) {
            this.consumeLine(s1);
        }
    }

    private String createConsoleMessage(String remaining) {
        return this.unescape(remaining);
    }

    private ReportEntry createReportEntry(String untokenized) {
        StringTokenizer tokens = new StringTokenizer(untokenized, ",");
        try {
            String source = this.nullableCsv(tokens.nextToken());
            String name = this.nullableCsv(tokens.nextToken());
            String group = this.nullableCsv(tokens.nextToken());
            String message = this.nullableCsv(tokens.nextToken());
            String elapsedStr = tokens.nextToken();
            Integer elapsed = "null".equals(elapsedStr) ? null : Integer.decode(elapsedStr);
            StackTraceWriter stackTraceWriter = tokens.hasMoreTokens() ? this.deserializeStackStraceWriter(tokens) : null;
            return CategorizedReportEntry.reportEntry((String)source, (String)name, (String)group, (StackTraceWriter)stackTraceWriter, (Integer)elapsed, (String)message);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(untokenized, e);
        }
    }

    private StackTraceWriter deserializeStackStraceWriter(StringTokenizer tokens) {
        String stackTraceMessage = this.nullableCsv(tokens.nextToken());
        String smartStackTrace = this.nullableCsv(tokens.nextToken());
        String stackTrace = tokens.hasMoreTokens() ? this.nullableCsv(tokens.nextToken()) : null;
        DeserializedStacktraceWriter stackTraceWriter = stackTrace != null ? new DeserializedStacktraceWriter(stackTraceMessage, smartStackTrace, stackTrace) : null;
        return stackTraceWriter;
    }

    private String nullableCsv(String source) {
        if ("null".equals(source)) {
            return null;
        }
        return this.unescape(source);
    }

    private String unescape(String source) {
        StringBuilder stringBuffer = new StringBuilder(source.length());
        StringUtils.unescapeString((StringBuilder)stringBuffer, (CharSequence)source);
        return stringBuffer.toString();
    }

    public RunListener getReporter(Integer channelNumber) {
        return this.testSetReporters.get(channelNumber);
    }

    private RunListener getOrCreateReporter(Integer channelNumber) {
        RunListener reporter = this.testSetReporters.get(channelNumber);
        if (reporter == null) {
            reporter = this.defaultReporterFactory.createReporter();
            this.testSetReporters.put(channelNumber, reporter);
        }
        return reporter;
    }

    private ConsoleOutputReceiver getOrCreateConsoleOutputReceiver(Integer channelNumber) {
        return (ConsoleOutputReceiver)this.getOrCreateReporter(channelNumber);
    }

    private ConsoleLogger getOrCreateConsoleLogger(Integer channelNumber) {
        return (ConsoleLogger)this.getOrCreateReporter(channelNumber);
    }

    public void close(boolean hadTimeout) {
    }

    public boolean isSaidGoodBye() {
        return this.saidGoodBye;
    }

    public StackTraceWriter getErrorInFork() {
        return this.errorInFork;
    }

    public boolean isErrorInFork() {
        return this.errorInFork != null;
    }
}

