/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.TestSetReportEntry;

public class MockReporter
implements RunListener {
    private final List<String> events = new ArrayList<String>();
    public static final String SET_STARTED = "SET_STARTED";
    public static final String SET_COMPLETED = "SET_COMPLETED";
    public static final String TEST_STARTED = "TEST_STARTED";
    public static final String TEST_COMPLETED = "TEST_COMPLETED";
    public static final String TEST_SKIPPED = "TEST_SKIPPED";
    private final AtomicInteger testSucceeded = new AtomicInteger();
    private final AtomicInteger testIgnored = new AtomicInteger();
    private final AtomicInteger testFailed = new AtomicInteger();
    private final AtomicInteger testError = new AtomicInteger();

    public void testSetStarting(TestSetReportEntry report) {
        this.events.add(SET_STARTED);
    }

    public void testSetCompleted(TestSetReportEntry report) {
        this.events.add(SET_COMPLETED);
    }

    public void testStarting(ReportEntry report) {
        this.events.add(TEST_STARTED);
    }

    public void testSucceeded(ReportEntry report) {
        this.events.add(TEST_COMPLETED);
        this.testSucceeded.incrementAndGet();
    }

    public void testSkipped(ReportEntry report) {
        this.events.add(TEST_SKIPPED);
        this.testIgnored.incrementAndGet();
    }

    public void testExecutionSkippedByUser() {
    }

    public void testSkippedByUser(ReportEntry report) {
        this.testSkipped(report);
    }

    public int getTestSucceeded() {
        return this.testSucceeded.get();
    }

    public int getTestFailed() {
        return this.testFailed.get();
    }

    public void testError(ReportEntry report) {
        this.testError.incrementAndGet();
    }

    public void testFailed(ReportEntry report) {
        this.testFailed.incrementAndGet();
    }

    public void testAssumptionFailure(ReportEntry report) {
    }

    public boolean containsNotification(String event) {
        return this.events.contains(event);
    }
}

