/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.it;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.maven.it.LauncherException;
import org.apache.maven.it.MavenLauncher;

class Classpath3xLauncher
implements MavenLauncher {
    private final Object mavenCli;
    private final Method doMain;

    public Classpath3xLauncher() throws LauncherException {
        ClassLoader coreLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> cliClass = coreLoader.loadClass("org.apache.maven.cli.MavenCli");
            this.mavenCli = cliClass.newInstance();
            Class[] parameterTypes = new Class[]{String[].class, String.class, PrintStream.class, PrintStream.class};
            this.doMain = cliClass.getMethod("doMain", parameterTypes);
        }
        catch (ClassNotFoundException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new LauncherException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new LauncherException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] cliArgs, String workingDirectory, File logFile) throws IOException, LauncherException {
        PrintStream out = logFile != null ? new PrintStream(new FileOutputStream(logFile)) : System.out;
        try {
            int n;
            Properties originalProperties = System.getProperties();
            System.setProperties(null);
            System.setProperty("maven.home", originalProperties.getProperty("maven.home", ""));
            System.setProperty("user.dir", new File(workingDirectory).getAbsolutePath());
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.mavenCli.getClass().getClassLoader());
            try {
                Object result = this.doMain.invoke(this.mavenCli, cliArgs, workingDirectory, out, out);
                n = ((Number)result).intValue();
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            catch (Throwable throwable) {
                try {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    System.setProperties(originalProperties);
                    throw throwable;
                }
                catch (IllegalAccessException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new LauncherException("Failed to run Maven: " + e.getMessage(), e);
                }
            }
            System.setProperties(originalProperties);
            return n;
        }
        finally {
            if (logFile != null) {
                out.close();
            }
        }
    }
}

