/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.classes;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.classes.ImportVisitor;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class JarClassesAnalysis {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Map<Double, String> JAVA_CLASS_VERSIONS;

    public JarClasses analyze(JarAnalyzer jarAnalyzer) {
        JarClasses classes = jarAnalyzer.getJarData().getJarClasses();
        if (classes == null) {
            String jarfilename = jarAnalyzer.getFile().getAbsolutePath();
            classes = new JarClasses();
            List<JarEntry> classList = jarAnalyzer.getClassEntries();
            classes.setDebugPresent(false);
            double maxVersion = 0.0;
            for (JarEntry entry : classList) {
                String classname = entry.getName();
                try {
                    Method[] methods;
                    ClassParser classParser = new ClassParser(jarfilename, classname);
                    JavaClass javaClass = classParser.parse();
                    String classSignature = javaClass.getClassName();
                    if (!classes.isDebugPresent() && this.hasDebugSymbols(javaClass)) {
                        classes.setDebugPresent(true);
                    }
                    double classVersion = javaClass.getMajor();
                    if (javaClass.getMinor() > 0) {
                        classVersion += (double)javaClass.getMinor() / 10.0;
                    }
                    if (classVersion > maxVersion) {
                        maxVersion = classVersion;
                    }
                    for (Method method : methods = javaClass.getMethods()) {
                        classes.addMethod(classSignature + "." + method.getName() + method.getSignature());
                    }
                    String classPackageName = javaClass.getPackageName();
                    classes.addClassName(classSignature);
                    classes.addPackage(classPackageName);
                    ImportVisitor importVisitor = new ImportVisitor(javaClass);
                    DescendingVisitor descVisitor = new DescendingVisitor(javaClass, (Visitor)importVisitor);
                    javaClass.accept((Visitor)descVisitor);
                    classes.addImports(importVisitor.getImports());
                }
                catch (ClassFormatException e) {
                    this.logger.warn("Unable to process class " + classname + " in JarAnalyzer File " + jarfilename, (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.warn("Unable to process JarAnalyzer File " + jarfilename, (Throwable)e);
                }
            }
            Optional.ofNullable(JAVA_CLASS_VERSIONS.get(maxVersion)).ifPresent(classes::setJdkRevision);
            jarAnalyzer.getJarData().setJarClasses(classes);
        }
        return classes;
    }

    private boolean hasDebugSymbols(JavaClass javaClass) {
        Method[] methods;
        boolean ret = false;
        for (Method method : methods = javaClass.getMethods()) {
            LineNumberTable linenumbers = method.getLineNumberTable();
            if (linenumbers == null || linenumbers.getLength() <= 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    static {
        HashMap<Double, String> aMap = new HashMap<Double, String>();
        aMap.put(65.0, "21");
        aMap.put(64.0, "20");
        aMap.put(63.0, "19");
        aMap.put(62.0, "18");
        aMap.put(61.0, "17");
        aMap.put(60.0, "16");
        aMap.put(59.0, "15");
        aMap.put(58.0, "14");
        aMap.put(57.0, "13");
        aMap.put(56.0, "12");
        aMap.put(55.0, "11");
        aMap.put(54.0, "10");
        aMap.put(53.0, "9");
        aMap.put(52.0, "1.8");
        aMap.put(51.0, "1.7");
        aMap.put(50.0, "1.6");
        aMap.put(49.0, "1.5");
        aMap.put(48.0, "1.4");
        aMap.put(47.0, "1.3");
        aMap.put(46.0, "1.2");
        aMap.put(45.3, "1.1");
        JAVA_CLASS_VERSIONS = Collections.unmodifiableMap(aMap);
    }
}

