/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.command.unedit;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.unedit.AbstractUnEditCommand;
import org.apache.maven.scm.command.unedit.UnEditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.synergy.command.SynergyCommand;
import org.apache.maven.scm.provider.synergy.repository.SynergyScmProviderRepository;
import org.apache.maven.scm.provider.synergy.util.SynergyUtil;
import org.codehaus.plexus.util.FileUtils;

public class SynergyUnEditCommand
extends AbstractUnEditCommand
implements SynergyCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ScmResult executeUnEditCommand(ScmProviderRepository repository, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("executing unedit command...");
        }
        SynergyScmProviderRepository repo = (SynergyScmProviderRepository)repository;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("basedir: " + fileSet.getBasedir());
        }
        String ccmAddr = SynergyUtil.start(this.getLogger(), repo.getUser(), repo.getPassword(), null);
        try {
            String projectSpec = SynergyUtil.getWorkingProject(this.getLogger(), repo.getProjectSpec(), repo.getUser(), ccmAddr);
            if (projectSpec == null) {
                throw new ScmException("You should checkout project first");
            }
            File waPath = SynergyUtil.getWorkArea(this.getLogger(), projectSpec, ccmAddr);
            File destPath = new File(waPath, repo.getProjectName());
            Iterator i = fileSet.getFileList().iterator();
            while (i.hasNext()) {
                ScmFile f = (ScmFile)i.next();
                File source = new File(fileSet.getBasedir(), f.getPath());
                File dest = new File(destPath, f.getPath());
                SynergyUtil.delete(this.getLogger(), dest, ccmAddr, true);
                if (source.equals(dest)) continue;
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Copy file [" + dest + "] to [" + source + "].");
                }
                try {
                    FileUtils.copyFile((File)dest, (File)source);
                }
                catch (IOException e) {
                    throw new ScmException("Unable to restore file in output folder", (Throwable)e);
                    return new UnEditScmResult("", fileSet.getFileList());
                }
            }
        }
        finally {
            SynergyUtil.stop(this.getLogger(), ccmAddr);
        }
    }
}

