/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.synergy.repository;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class SynergyScmProviderRepository
extends ScmProviderRepository {
    private String project_spec;
    private String project_name;
    private String project_version;
    private String project_release;
    private String project_purpose;
    private String delimiter;

    public SynergyScmProviderRepository(String url) throws ScmRepositoryException {
        System.out.println("DEBUG");
        try {
            this.parseUrl(url);
        }
        catch (MalformedURLException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (URISyntaxException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
        catch (UnknownHostException e) {
            throw new ScmRepositoryException("Illegal URL: " + url + "(" + e.getMessage() + ")");
        }
    }

    private void parseUrl(String url) throws MalformedURLException, URISyntaxException, UnknownHostException {
        if (url.indexOf(124) != -1) {
            StringTokenizer tokenizer = new StringTokenizer(url, "|");
            this.fillInProperties(tokenizer);
        } else {
            StringTokenizer tokenizer = new StringTokenizer(url, ":");
            this.fillInProperties(tokenizer);
        }
    }

    private void fillInProperties(StringTokenizer tokenizer) throws UnknownHostException, URISyntaxException, MalformedURLException {
        if (tokenizer.countTokens() != 5) {
            throw new MalformedURLException();
        }
        this.project_name = tokenizer.nextToken();
        this.delimiter = tokenizer.nextToken();
        this.project_version = tokenizer.nextToken();
        this.project_release = tokenizer.nextToken();
        this.project_purpose = tokenizer.nextToken();
        this.project_spec = this.project_name + this.delimiter + this.project_version;
    }

    public String getProjectSpec() {
        return this.project_spec;
    }

    public String getProjectName() {
        return this.project_name;
    }

    public String getProjectVersion() {
        return this.project_version;
    }

    public String getProjectPurpose() {
        return this.project_purpose;
    }

    public String getProjectRelease() {
        return this.project_release;
    }
}

