/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.remoteinfo;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remoteinfo.AbstractRemoteInfoCommand;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.util.AbstractConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnRemoteInfoCommand
extends AbstractRemoteInfoCommand
implements SvnCommand {
    public RemoteInfoScmResult executeRemoteInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        String url = ((SvnScmProviderRepository)repository).getUrl();
        url = StringUtils.stripEnd((String)url, (String)"/");
        int idx = url.lastIndexOf("/");
        String baseUrl = url.substring(0, idx);
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet == null ? null : fileSet.getBasedir(), (SvnScmProviderRepository)repository);
        cl.createArg().setValue("ls");
        cl.createArg().setValue(baseUrl + "/tags@");
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        LsConsumer consumer = new LsConsumer(baseUrl + "/tags");
        int exitCode = 0;
        Map<String, String> tagsInfos = null;
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
            tagsInfos = consumer.infos;
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing svn command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new RemoteInfoScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet == null ? null : fileSet.getBasedir(), (SvnScmProviderRepository)repository);
        cl.createArg().setValue("ls");
        cl.createArg().setValue(baseUrl + "/branches@");
        stderr = new CommandLineUtils.StringStreamConsumer();
        consumer = new LsConsumer(baseUrl + "/branches");
        Map<String, String> branchesInfos = null;
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
            branchesInfos = consumer.infos;
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing svn command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new RemoteInfoScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new RemoteInfoScmResult(cl.toString(), branchesInfos, tagsInfos);
    }

    public boolean remoteUrlExist(ScmProviderRepository repository, CommandParameters parameters) throws ScmException {
        String url = ((SvnScmProviderRepository)repository).getUrl();
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(null, (SvnScmProviderRepository)repository);
        cl.createArg().setValue("ls");
        cl.createArg().setValue(url + "@");
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        LsConsumer consumer = new LsConsumer(url);
        int exitCode = 0;
        try {
            exitCode = SvnCommandLineUtils.execute(cl, (StreamConsumer)consumer, stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing svn command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            String output = stderr.getOutput();
            if (output.contains("W160013") || output.contains("svn: URL")) {
                return false;
            }
            throw new ScmException(cl + ".The svn command failed:" + stderr.getOutput());
        }
        return true;
    }

    private static class LsConsumer
    extends AbstractConsumer {
        Map<String, String> infos = new HashMap<String, String>();
        String url;

        LsConsumer(String url) {
            this.url = url;
        }

        public void consumeLine(String s) {
            this.infos.put(StringUtils.stripEnd((String)s, (String)"/"), this.url + "/" + s);
        }

        Map<String, String> getInfos() {
            return this.infos;
        }
    }
}

