/*
 * $Id$
 */

package org.apache.maven.scm.providers.svn.settings;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Settings.
 * 
 * @version $Revision$ $Date$
 */
public class Settings implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *              Instructs Subversion to read configuration
     * information from the specified directory instead of the
     * default location.
     *           
     */
    private String configDirectory;

    /**
     * 
     *              Must be true if svn is a cygwin svn command.
     *           
     */
    private boolean useCygwinPath = false;

    /**
     * 
     *              The cygwin mount path. The default value is
     * '/cygwin'.
     *           
     */
    private String cygwinMountPath = "/cygwin";

    /**
     * 
     *              Switch off if you do not like to use
     * --non-interactive e.g. on Leopard (see SCM-402).
     *           
     */
    private boolean useNonInteractive = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *              Instructs Subversion to read configuration
     * information from the specified directory instead of the
     * default location.
     *           
     * 
     * @return String
     */
    public String getConfigDirectory()
    {
        return this.configDirectory;
    } //-- String getConfigDirectory() 

    /**
     * Get 
     *              The cygwin mount path. The default value is
     * '/cygwin'.
     *           
     * 
     * @return String
     */
    public String getCygwinMountPath()
    {
        return this.cygwinMountPath;
    } //-- String getCygwinMountPath() 

    /**
     * Get 
     *              Must be true if svn is a cygwin svn command.
     *           
     * 
     * @return boolean
     */
    public boolean isUseCygwinPath()
    {
        return this.useCygwinPath;
    } //-- boolean isUseCygwinPath() 

    /**
     * Get 
     *              Switch off if you do not like to use
     * --non-interactive e.g. on Leopard (see SCM-402).
     *           
     * 
     * @return boolean
     */
    public boolean isUseNonInteractive()
    {
        return this.useNonInteractive;
    } //-- boolean isUseNonInteractive() 

    /**
     * Set 
     *              Instructs Subversion to read configuration
     * information from the specified directory instead of the
     * default location.
     *           
     * 
     * @param configDirectory
     */
    public void setConfigDirectory(String configDirectory)
    {
        this.configDirectory = configDirectory;
    } //-- void setConfigDirectory(String) 

    /**
     * Set 
     *              The cygwin mount path. The default value is
     * '/cygwin'.
     *           
     * 
     * @param cygwinMountPath
     */
    public void setCygwinMountPath(String cygwinMountPath)
    {
        this.cygwinMountPath = cygwinMountPath;
    } //-- void setCygwinMountPath(String) 

    /**
     * Set 
     *              Must be true if svn is a cygwin svn command.
     *           
     * 
     * @param useCygwinPath
     */
    public void setUseCygwinPath(boolean useCygwinPath)
    {
        this.useCygwinPath = useCygwinPath;
    } //-- void setUseCygwinPath(boolean) 

    /**
     * Set 
     *              Switch off if you do not like to use
     * --non-interactive e.g. on Leopard (see SCM-402).
     *           
     * 
     * @param useNonInteractive
     */
    public void setUseNonInteractive(boolean useNonInteractive)
    {
        this.useNonInteractive = useNonInteractive;
    } //-- void setUseNonInteractive(boolean) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
