/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.apache.maven.scm.provider.perforce.command.PerforceVerbMapper;
import org.apache.regexp.RE;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckOutConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    public static final int STATE_CLIENTSPEC = 0;
    public static final int STATE_NORMAL = 1;
    public static final int STATE_ERROR = 2;
    private int currentState = 0;
    private RE fileRegexp = new RE("([^#]+)#\\d+ - ([a-z]+)");
    private List checkedout = new ArrayList();
    private String repo = null;
    private String specname = null;

    public PerforceCheckOutConsumer(String clientspec, String repoPath) {
        this.repo = repoPath;
        this.specname = clientspec;
    }

    public void consumeLine(String line) {
        if (this.currentState == 0 && (line.startsWith("Client " + this.specname + " saved.") || line.startsWith("Client " + this.specname + " not changed."))) {
            this.currentState = 1;
            return;
        }
        if (this.currentState == 1 && line.indexOf("ile(s) up-to-date") != -1) {
            return;
        }
        if (this.currentState != 2 && this.fileRegexp.match(line)) {
            ScmFileStatus status;
            String location = this.fileRegexp.getParen(1);
            if (location.startsWith(this.repo)) {
                location = location.substring(this.repo.length() + 1);
            }
            if ((status = PerforceVerbMapper.toStatus(this.fileRegexp.getParen(2))) != null) {
                this.checkedout.add(new ScmFile(location, status));
            }
            return;
        }
        this.error(line);
    }

    private void error(String line) {
        this.currentState = 2;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 1;
    }

    public List getCheckedout() {
        return this.checkedout;
    }
}

