/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkin.PerforceCheckInConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckInCommand
extends AbstractCheckInCommand
implements PerforceCommand {
    private static final String NEWLINE = "\r\n";

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet files, String message, ScmVersion version) throws ScmException {
        PerforceCheckInConsumer consumer;
        Commandline cl;
        block5: {
            cl = PerforceCheckInCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir());
            consumer = new PerforceCheckInConsumer();
            try {
                CommandLineUtils.StringStreamConsumer err;
                int exitCode;
                String jobs = System.getProperty("maven.scm.jobs");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(PerforceScmProvider.clean("Executing " + cl.toString()));
                }
                PerforceScmProviderRepository prepo = (PerforceScmProviderRepository)repo;
                String changes = PerforceCheckInCommand.createChangeListSpecification(prepo, files, message, PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir()), jobs);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Sending changelist:\n" + changes);
                }
                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)new StringBufferInputStream(changes), (StreamConsumer)consumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block5;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        return new CheckInScmResult(cl.toString(), consumer.isSuccess() ? "Checkin successful" : "Unable to submit", consumer.getOutput(), consumer.isSuccess());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("submit");
        command.createArg().setValue("-i");
        return command;
    }

    public static String createChangeListSpecification(PerforceScmProviderRepository repo, ScmFileSet files, String msg, String canonicalPath, String jobs) {
        StringBuffer buf = new StringBuffer();
        buf.append("Change: new").append(NEWLINE).append(NEWLINE);
        buf.append("Description:").append(NEWLINE).append("\t").append(msg).append(NEWLINE).append(NEWLINE);
        if (jobs != null && jobs.length() != 0) {
            buf.append("Jobs:").append(NEWLINE).append("\t").append(jobs).append(NEWLINE).append(NEWLINE);
        }
        buf.append("Files:").append(NEWLINE);
        try {
            HashSet<String> dupes = new HashSet<String>();
            File workingDir = files.getBasedir();
            String candir = workingDir.getCanonicalPath();
            List fs = files.getFileList();
            for (int i = 0; i < fs.size(); ++i) {
                File file = (File)fs.get(i);
                String canfile = file.getCanonicalPath();
                if (dupes.contains(canfile)) {
                    System.err.println("Skipping duplicate file: " + file);
                    continue;
                }
                dupes.add(canfile);
                if (canfile.startsWith(candir)) {
                    canfile = canfile.substring(candir.length() + 1);
                }
                buf.append("\t").append(canonicalPath).append("/").append(canfile.replace('\\', '/')).append(NEWLINE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }
}

