/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckOutCommand
extends AbstractCheckOutCommand
implements PerforceCommand {
    private String actualLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion version, boolean recursive, boolean shallow) throws ScmException {
        Commandline cl;
        PerforceCheckOutConsumer consumer;
        String specname;
        File workingDirectory;
        PerforceScmProviderRepository prepo;
        block48: {
            prepo = (PerforceScmProviderRepository)repo;
            workingDirectory = new File(files.getBasedir().getAbsolutePath());
            this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
            specname = PerforceScmProvider.getClientspecName(this.getLogger(), prepo, workingDirectory);
            consumer = new PerforceCheckOutConsumer(specname, this.actualLocation);
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Checkout working directory: " + workingDirectory);
            }
            cl = null;
            try {
                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                cl.createArg().setValue("client");
                cl.createArg().setValue("-i");
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                }
                String client = PerforceScmProvider.createClientspec(this.getLogger(), prepo, workingDirectory, this.actualLocation);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Updating clientspec:\n" + client);
                }
                CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
                int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)new ByteArrayInputStream(client.getBytes()), (StreamConsumer)consumer, (StreamConsumer)err);
                if (exitCode != 0) {
                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                    StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                    msg.append('\n');
                    msg.append("Command line was:" + cmdLine);
                    throw new CommandLineException(msg.toString());
                }
            }
            catch (CommandLineException e) {
                if (!this.getLogger().isErrorEnabled()) break block48;
                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
            }
        }
        boolean clientspecExists = consumer.isSuccess();
        try {
            CheckOutScmResult checkOutScmResult;
            block49: {
                if (clientspecExists) {
                    try {
                        String line;
                        this.getLastChangelist(prepo, workingDirectory, specname);
                        cl = PerforceCheckOutCommand.createCommandLine(prepo, workingDirectory, version, specname);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Executing: " + PerforceScmProvider.clean(cl.toString()));
                        }
                        Process proc = cl.execute();
                        BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        while ((line = br.readLine()) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Consuming: " + line);
                            }
                            consumer.consumeLine(line);
                        }
                        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
                        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
                        if (exitCode != 0) {
                            String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                            StringBuilder msg = new StringBuilder("Exit code: " + exitCode + " - " + err.getOutput());
                            msg.append('\n');
                            msg.append("Command line was:" + cmdLine);
                            throw new CommandLineException(msg.toString());
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Perforce sync complete.");
                        }
                    }
                    catch (CommandLineException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!this.getLogger().isErrorEnabled()) break block49;
                        this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            if (consumer.isSuccess()) {
                checkOutScmResult = new CheckOutScmResult(cl.toString(), consumer.getCheckedout());
                return checkOutScmResult;
            }
            checkOutScmResult = new CheckOutScmResult(cl.toString(), "Unable to sync.  Are you logged in?", consumer.getOutput(), consumer.isSuccess());
            return checkOutScmResult;
        }
        finally {
            block50: {
                block51: {
                    if (!clientspecExists || prepo.isPersistCheckout()) break block51;
                    InputStreamReader isReader = null;
                    InputStreamReader isReaderErr = null;
                    try {
                        String line;
                        cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                        cl.createArg().setValue("client");
                        cl.createArg().setValue("-d");
                        cl.createArg().setValue(specname);
                        if (this.getLogger().isInfoEnabled()) {
                            this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                        }
                        Process proc = cl.execute();
                        isReader = new InputStreamReader(proc.getInputStream());
                        BufferedReader br = new BufferedReader(isReader);
                        while ((line = br.readLine()) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Consuming: " + line);
                            }
                            consumer.consumeLine(line);
                        }
                        br.close();
                        isReaderErr = new InputStreamReader(proc.getErrorStream());
                        BufferedReader brErr = new BufferedReader(isReaderErr);
                        while ((line = brErr.readLine()) != null) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Consuming stderr: " + line);
                            }
                            consumer.consumeLine(line);
                        }
                        brErr.close();
                        IOUtil.close((Reader)isReader);
                    }
                    catch (CommandLineException e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                        }
                        break block50;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        catch (IOException e2) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("IOException " + e2.getMessage(), (Throwable)e2);
                            }
                            break block50;
                        }
                    }
                    finally {
                        IOUtil.close(isReader);
                        IOUtil.close(isReaderErr);
                    }
                    IOUtil.close((Reader)isReaderErr);
                    break block50;
                }
                if (clientspecExists) {
                    System.setProperty("maven.scm.perforce.clientspec.name", specname);
                }
            }
        }
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmVersion version, String specname) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("-c" + specname);
        command.createArg().setValue("sync");
        String[] files = workingDirectory.list();
        if (files == null || files.length == 0) {
            command.createArg().setValue("-f");
        }
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            command.createArg().setValue("@" + version.getName());
        }
        return command;
    }

    private int getLastChangelist(PerforceScmProviderRepository repo, File workingDirectory, String specname) {
        int lastChangelist = 0;
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
            command.createArg().setValue("-c" + specname);
            command.createArg().setValue("changes");
            command.createArg().setValue("-m1");
            command.createArg().setValue("-ssubmitted");
            command.createArg().setValue("//" + specname + "/...");
            this.getLogger().debug("Executing: " + PerforceScmProvider.clean(command.toString()));
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String lastChangelistStr = "";
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                Pattern changeRegexp = Pattern.compile("Change (\\d+)");
                Matcher matcher = changeRegexp.matcher(line);
                if (!matcher.find()) continue;
                lastChangelistStr = matcher.group(1);
            }
            br.close();
            try {
                lastChangelist = Integer.parseInt(lastChangelistStr);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().debug("Could not parse changelist from line " + line);
            }
        }
        catch (IOException | CommandLineException e) {
            this.getLogger().error(e);
        }
        return lastChangelist;
    }
}

