/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.remove;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.remove.PerforceRemoveConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class PerforceRemoveCommand
extends AbstractRemoveCommand
implements PerforceCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet files, String message) throws ScmException {
        Commandline cl = PerforceRemoveCommand.createCommandLine((PerforceScmProviderRepository)repo, files.getBasedir(), files);
        PerforceRemoveConsumer consumer = new PerforceRemoveConsumer();
        try {
            String line;
            Process proc = cl.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (CommandLineException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovals());
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmFileSet files) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArgument().setValue("delete");
        List fs = files.getFileList();
        for (int i = 0; i < fs.size(); ++i) {
            File file = (File)fs.get(i);
            command.createArgument().setValue(file.getName());
        }
        return command;
    }
}

