/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.add;

import java.util.ArrayList;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceAddConsumer
implements StreamConsumer {
    private static final String PATTERN = "^([^#]+)#1 - (.*)";
    private static final String FILE_BEGIN_TOKEN = "//";
    private List additions = new ArrayList();
    private RE revisionRegexp;

    public PerforceAddConsumer() {
        try {
            this.revisionRegexp = new RE(PATTERN);
        }
        catch (RESyntaxException ignored) {
            ignored.printStackTrace();
        }
    }

    public List getAdditions() {
        return this.additions;
    }

    public void consumeLine(String line) {
        if (line.startsWith("... ")) {
            return;
        }
        if (!line.startsWith(FILE_BEGIN_TOKEN)) {
            throw new IllegalStateException("Unknown error: " + line);
        }
        if (!this.revisionRegexp.match(line)) {
            throw new IllegalStateException("Unknown input: " + line);
        }
        this.additions.add(this.revisionRegexp.getParen(1));
    }
}

