/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.edit;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.AbstractEditCommand;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.consumer.DebugLoggerConsumer;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzEditCommand
extends AbstractEditCommand {
    protected ScmResult executeEditCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing edit command...");
        }
        DebugLoggerConsumer editConsumer = new DebugLoggerConsumer(this.getLogger());
        ErrorConsumer errConsumer = new ErrorConsumer(this.getLogger());
        JazzScmCommand editCmd = this.createEditCommand(repo, fileSet);
        int status = editCmd.execute((StreamConsumer)editConsumer, errConsumer);
        if (status != 0) {
            return new EditScmResult(editCmd.getCommandString(), "Error code for Jazz SCM edit command - " + status, errConsumer.getOutput(), false);
        }
        return new EditScmResult(editCmd.getCommandString(), "Successfully Completed.", editConsumer.getOutput(), true);
    }

    protected JazzScmCommand createEditCommand(ScmProviderRepository repo, ScmFileSet fileSet) {
        JazzScmCommand command = new JazzScmCommand("lock", "acquire", repo, fileSet, this.getLogger());
        List files = fileSet.getFileList();
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                command.addArgument(file.getPath());
            }
        } else {
            command.addArgument(".");
        }
        return command;
    }
}

