/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remoteinfo;

import java.util.HashMap;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitRemoteInfoConsumer
implements StreamConsumer {
    private static final String BRANCH_PATTERN = "^(.*)\\s+refs/heads/(.*)";
    private static final String TAGS_PATTERN = "^(.*)\\s+refs/tags/(.*)";
    private ScmLogger logger;
    private RemoteInfoScmResult remoteInfoScmResult;
    private RE branchRegexp;
    private RE tagRegexp;

    public GitRemoteInfoConsumer(ScmLogger logger, String commandLine) {
        this.logger = logger;
        this.remoteInfoScmResult = new RemoteInfoScmResult(commandLine, new HashMap(), new HashMap());
        try {
            this.branchRegexp = new RE(BRANCH_PATTERN);
            this.tagRegexp = new RE(TAGS_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse git ls-remote file. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    public void consumeLine(String line) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (this.branchRegexp.match(line)) {
            this.remoteInfoScmResult.getBranches().put(this.branchRegexp.getParen(2), this.branchRegexp.getParen(1));
        }
        if (this.tagRegexp.match(line)) {
            this.remoteInfoScmResult.getTags().put(this.tagRegexp.getParen(2), this.tagRegexp.getParen(1));
        }
    }

    public RemoteInfoScmResult getRemoteInfoScmResult() {
        return this.remoteInfoScmResult;
    }
}

