/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.add;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusCommand;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class GitAddCommand
extends AbstractAddCommand
implements GitCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        GitStatusConsumer statusConsumer;
        CommandLineUtils.StringStreamConsumer stderr;
        CommandLineUtils.StringStreamConsumer stdout;
        GitScmProviderRepository repository = (GitScmProviderRepository)repo;
        if (fileSet.getFileList().isEmpty()) {
            throw new ScmException("You must provide at least one file/directory to add");
        }
        Commandline cl = GitAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        int exitCode = GitCommandLineUtils.execute(cl, stdout = new CommandLineUtils.StringStreamConsumer(), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new AddScmResult(cl.toString(), "The git-add command failed.", stderr.getOutput(), false);
        }
        Commandline clStatus = GitStatusCommand.createCommandLine(repository, fileSet);
        exitCode = GitCommandLineUtils.execute(clStatus, statusConsumer = new GitStatusConsumer(this.getLogger(), fileSet.getBasedir()), stderr, this.getLogger());
        if (exitCode != 0 && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("nothing added to commit but untracked files present (use \"git add\" to track)");
        }
        ArrayList<ScmFile> changedFiles = new ArrayList<ScmFile>();
        Iterator it = statusConsumer.getChangedFiles().iterator();
        while (it.hasNext()) {
            ScmFile scmfile = (ScmFile)it.next();
            Iterator itfl = fileSet.getFileList().iterator();
            while (itfl.hasNext()) {
                File f = (File)itfl.next();
                if (!f.toString().equals(scmfile.getPath())) continue;
                changedFiles.add(scmfile);
            }
        }
        return new AddScmResult(cl.toString(), changedFiles);
    }

    public static Commandline createCommandLine(File workingDirectory, List files) throws ScmException {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "add");
        GitCommandLineUtils.addTarget(cl, files);
        return cl;
    }
}

