/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.repository;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.git.repository.RepositoryUrl;

public class GitScmProviderRepository
extends ScmProviderRepositoryWithHost {
    public static final String URL_DELIMITER_FETCH = "[fetch=]";
    public static final String URL_DELIMITER_PUSH = "[push=]";
    public static final String PROTOCOL_SEPARATOR = "://";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_GIT = "git";
    public static final String PROTOCOL_SSH = "ssh";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_RSYNC = "rsync";
    public static final String PROTOCOL_NONE = "";
    private String provider;
    private RepositoryUrl fetchInfo;
    private RepositoryUrl pushInfo;

    public GitScmProviderRepository(String url) throws ScmException {
        if (url == null) {
            throw new ScmException("url must not be null");
        }
        if (url.startsWith(URL_DELIMITER_FETCH)) {
            String fetch = url.substring(URL_DELIMITER_FETCH.length());
            int indexPushDelimiter = fetch.indexOf(URL_DELIMITER_PUSH);
            if (indexPushDelimiter >= 0) {
                String push = fetch.substring(indexPushDelimiter + URL_DELIMITER_PUSH.length());
                this.pushInfo = this.parseUrl(push);
                fetch = fetch.substring(0, indexPushDelimiter);
            }
            this.fetchInfo = this.parseUrl(fetch);
            if (this.pushInfo == null) {
                this.pushInfo = this.fetchInfo;
            }
        } else if (url.startsWith(URL_DELIMITER_PUSH)) {
            String push = url.substring(URL_DELIMITER_PUSH.length());
            int indexFetchDelimiter = push.indexOf(URL_DELIMITER_FETCH);
            if (indexFetchDelimiter >= 0) {
                String fetch = push.substring(indexFetchDelimiter + URL_DELIMITER_FETCH.length());
                this.fetchInfo = this.parseUrl(fetch);
                push = push.substring(0, indexFetchDelimiter);
            }
            this.pushInfo = this.parseUrl(push);
            if (this.fetchInfo == null) {
                this.fetchInfo = this.pushInfo;
            }
        } else {
            this.fetchInfo = this.pushInfo = this.parseUrl(url);
        }
        this.setUser(this.pushInfo.getUserName());
        this.setPassword(this.pushInfo.getPassword());
        this.setHost(this.pushInfo.getHost());
        if (this.pushInfo.getPort() != null && this.pushInfo.getPort().length() > 0) {
            this.setPort(Integer.parseInt(this.pushInfo.getPort()));
        }
    }

    public GitScmProviderRepository(String url, String user, String password) throws ScmException {
        this(url);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getProvider() {
        return this.provider;
    }

    public RepositoryUrl getFetchInfo() {
        return this.fetchInfo;
    }

    public RepositoryUrl getPushInfo() {
        return this.pushInfo;
    }

    public String getFetchUrl() {
        return this.getUrl(this.fetchInfo);
    }

    public String getPushUrl() {
        return this.getUrl(this.pushInfo);
    }

    private RepositoryUrl parseUrl(String url) throws ScmException {
        RepositoryUrl repoUrl = new RepositoryUrl();
        url = this.parseProtocol(repoUrl, url);
        url = this.parseUserInfo(repoUrl, url);
        url = this.parseHostAndPort(repoUrl, url);
        repoUrl.setPath(url);
        return repoUrl;
    }

    private String getUrl(RepositoryUrl repoUrl) {
        StringBuffer urlSb = new StringBuffer(repoUrl.getProtocol());
        boolean urlSupportsUserInformation = false;
        if (PROTOCOL_SSH.equals(repoUrl.getProtocol()) || PROTOCOL_RSYNC.equals(repoUrl.getProtocol()) || PROTOCOL_GIT.equals(repoUrl.getProtocol()) || PROTOCOL_HTTP.equals(repoUrl.getProtocol()) || PROTOCOL_HTTPS.equals(repoUrl.getProtocol()) || PROTOCOL_NONE.equals(repoUrl.getProtocol())) {
            urlSupportsUserInformation = true;
        }
        if (repoUrl.getProtocol() != null && repoUrl.getProtocol().length() > 0) {
            urlSb.append(PROTOCOL_SEPARATOR);
        }
        if (urlSupportsUserInformation) {
            String userName = repoUrl.getUserName();
            if (this.getUser() != null && this.getUser().length() > 0) {
                userName = this.getUser();
            }
            String password = repoUrl.getPassword();
            if (this.getPassword() != null && this.getPassword().length() > 0) {
                password = this.getPassword();
            }
            if (userName != null && userName.length() > 0) {
                urlSb.append(userName);
                if (password != null && password.length() > 0) {
                    urlSb.append(':').append(password);
                }
                urlSb.append('@');
            }
        }
        urlSb.append(repoUrl.getHost());
        if (repoUrl.getPort() != null && repoUrl.getPort().length() > 0) {
            urlSb.append(':').append(repoUrl.getPort());
        }
        urlSb.append(repoUrl.getPath());
        return urlSb.toString();
    }

    private String parseProtocol(RepositoryUrl repoUrl, String url) throws ScmException {
        if (url.startsWith("file://")) {
            repoUrl.setProtocol(PROTOCOL_FILE);
        } else if (url.startsWith("https://")) {
            repoUrl.setProtocol(PROTOCOL_HTTPS);
        } else if (url.startsWith("http://")) {
            repoUrl.setProtocol(PROTOCOL_HTTP);
        } else if (url.startsWith("ssh://")) {
            repoUrl.setProtocol(PROTOCOL_SSH);
        } else if (url.startsWith("git://")) {
            repoUrl.setProtocol(PROTOCOL_GIT);
        } else if (url.startsWith("rsync://")) {
            repoUrl.setProtocol(PROTOCOL_RSYNC);
        } else {
            repoUrl.setProtocol(PROTOCOL_NONE);
            return url;
        }
        url = url.substring(repoUrl.getProtocol().length() + 3);
        return url;
    }

    private String parseUserInfo(RepositoryUrl repoUrl, String url) throws ScmException {
        int indexAt = url.indexOf("@");
        if (indexAt >= 0) {
            String userInfo = url.substring(0, indexAt);
            int indexPwdSep = userInfo.indexOf(":");
            if (indexPwdSep < 0) {
                repoUrl.setUserName(userInfo);
            } else {
                repoUrl.setUserName(userInfo.substring(0, indexPwdSep));
                repoUrl.setPassword(userInfo.substring(indexPwdSep + 1));
            }
            url = url.substring(indexAt + 1);
        }
        return url;
    }

    private String parseHostAndPort(RepositoryUrl repoUrl, String url) throws ScmException {
        StringBuffer host = new StringBuffer();
        StringBuffer port = new StringBuffer();
        int i = 0;
        boolean isPort = false;
        while (i < url.length()) {
            char c = url.charAt(i);
            if (c == ':') {
                ++i;
                isPort = true;
                continue;
            }
            if (c == '/' || c == '\\' || c == '~') break;
            if (isPort) {
                if (!Character.isDigit(c)) {
                    --i;
                    break;
                }
                port.append(c);
                ++i;
                continue;
            }
            host.append(c);
            ++i;
        }
        repoUrl.setHost(host.toString());
        repoUrl.setPort(port.toString());
        url = url.substring(i);
        return url;
    }

    public String getRelativePath(ScmProviderRepository ancestor) {
        if (ancestor instanceof GitScmProviderRepository) {
            GitScmProviderRepository gitAncestor = (GitScmProviderRepository)ancestor;
            String url = this.getFetchUrl();
            String path = url.replaceFirst(gitAncestor.getFetchUrl() + "/", PROTOCOL_NONE);
            if (!path.equals(url)) {
                return path;
            }
        }
        return null;
    }

    public String toString() {
        if (this.fetchInfo == this.pushInfo) {
            return this.getUrl(this.fetchInfo);
        }
        return URL_DELIMITER_FETCH + this.getUrl(this.fetchInfo) + URL_DELIMITER_PUSH + this.getUrl(this.pushInfo);
    }
}

