/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.scm.providers.cvslib.settings.Settings;
import org.apache.maven.scm.providers.cvslib.settings.io.xpp3.CvsXpp3Reader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CvsUtil {
    protected static final String CVS_SETTINGS_FILENAME = "cvs-settings.xml";
    public static final File DEFAULT_SETTINGS_DIRECTORY;
    private static File settingsDirectory;
    private static Settings settings;

    private CvsUtil() {
    }

    public static Settings getSettings() {
        if (settings == null) {
            settings = CvsUtil.readSettings();
        }
        return settings;
    }

    public static Settings readSettings() {
        File settingsFile = CvsUtil.getSettingsFile();
        if (settingsFile.exists()) {
            CvsXpp3Reader reader = new CvsXpp3Reader();
            try {
                return reader.read((Reader)ReaderFactory.newXmlReader((File)settingsFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
            }
            catch (XmlPullParserException e) {
                String message = settingsFile.getAbsolutePath() + " isn't well formed. SKIPPED." + e.getMessage();
                System.err.println(message);
            }
        }
        return new Settings();
    }

    public static void setSettingsDirectory(File directory) {
        settingsDirectory = directory;
        settings = CvsUtil.readSettings();
    }

    public static File getSettingsFile() {
        return new File(settingsDirectory, CVS_SETTINGS_FILENAME);
    }

    static {
        settingsDirectory = DEFAULT_SETTINGS_DIRECTORY = new File(System.getProperty("user.home"), ".scm");
    }
}

