/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.scm;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.MavenCrypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultScmRepositoryConfigurator
implements ScmRepositoryConfigurator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<ScmManager> scmManager;
    private final MavenCrypto mavenCrypto;

    @Inject
    public DefaultScmRepositoryConfigurator(ScmManager scmManager, MavenCrypto mavenCrypto) {
        this.scmManager = new AtomicReference<ScmManager>(Objects.requireNonNull(scmManager));
        this.mavenCrypto = Objects.requireNonNull(mavenCrypto);
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager.set(scmManager);
    }

    @Override
    public ScmRepository getConfiguredRepository(ReleaseDescriptor releaseDescriptor, Settings settings) throws ScmRepositoryException, NoSuchScmProviderException {
        String url = releaseDescriptor.getScmSourceUrl();
        return this.getConfiguredRepository(url, releaseDescriptor, settings);
    }

    @Override
    public ScmRepository getConfiguredRepository(String url, ReleaseDescriptor releaseDescriptor, Settings settings) throws ScmRepositoryException, NoSuchScmProviderException {
        String username = releaseDescriptor.getScmUsername();
        String password = releaseDescriptor.getScmPassword();
        String privateKey = releaseDescriptor.getScmPrivateKey();
        String passphrase = releaseDescriptor.getScmPrivateKeyPassPhrase();
        ScmRepository repository = this.scmManager.get().makeScmRepository(url);
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        scmRepo.setPersistCheckout(false);
        if (settings != null) {
            Server server = null;
            if (releaseDescriptor.getScmId() != null && (server = settings.getServer(releaseDescriptor.getScmId())) == null) {
                this.logger.warn("No server with id '{}' found in Maven settings", (Object)releaseDescriptor.getScmId());
            }
            if (server == null && repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
                ScmProviderRepositoryWithHost repositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
                String host = repositoryWithHost.getHost();
                int port = repositoryWithHost.getPort();
                if (port > 0) {
                    host = host + ":" + port;
                }
                server = settings.getServer(host);
            }
            if (server != null) {
                if (username == null && server.getUsername() != null) {
                    this.logger.debug("Using username from server id '{}' found in Maven settings", (Object)releaseDescriptor.getScmId());
                    username = server.getUsername();
                }
                if (password == null && server.getPassword() != null) {
                    this.logger.debug("Using password from server id '{}' found in Maven settings", (Object)releaseDescriptor.getScmId());
                    password = this.decrypt(server.getPassword(), server.getId());
                }
                if (privateKey == null && server.getPrivateKey() != null) {
                    this.logger.debug("Using private key from server id '{}' found in Maven settings", (Object)releaseDescriptor.getScmId());
                    privateKey = server.getPrivateKey();
                }
                if (passphrase == null && server.getPassphrase() != null) {
                    this.logger.debug("Using passphrase from server id '{}' found in Maven settings", (Object)releaseDescriptor.getScmId());
                    passphrase = this.decrypt(server.getPassphrase(), server.getId());
                }
            }
        }
        if (username != null && !username.isEmpty()) {
            scmRepo.setUser(username);
        } else {
            this.logger.debug("No explicit username configured");
        }
        if (password != null && !password.isEmpty()) {
            scmRepo.setPassword(password);
        } else {
            this.logger.debug("No explicit password configured");
        }
        if (scmRepo instanceof ScmProviderRepositoryWithHost) {
            ScmProviderRepositoryWithHost repositoryWithHost = (ScmProviderRepositoryWithHost)scmRepo;
            if (privateKey != null && !privateKey.isEmpty()) {
                repositoryWithHost.setPrivateKey(privateKey);
            } else {
                this.logger.debug("No explicit private key configured");
            }
            if (passphrase != null && !passphrase.isEmpty()) {
                repositoryWithHost.setPassphrase(passphrase);
            } else {
                this.logger.debug("No explicit passphrase configured");
            }
        }
        if ("svn".equals(repository.getProvider())) {
            String branchBase;
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            String tagBase = releaseDescriptor.getScmTagBase();
            if (tagBase != null && !tagBase.isEmpty()) {
                svnRepo.setTagBase(tagBase);
            }
            if ((branchBase = releaseDescriptor.getScmBranchBase()) != null && !branchBase.isEmpty()) {
                svnRepo.setBranchBase(branchBase);
            }
        }
        if (!releaseDescriptor.isInteractive()) {
            this.scmManager.get().getProviderByRepository(repository).setInteractive(releaseDescriptor.isInteractive());
        }
        return repository;
    }

    private String decrypt(String str, String serverId) {
        try {
            return this.mavenCrypto.decrypt(str);
        }
        catch (MavenCrypto.MavenCryptoException e) {
            String msg = "Failed to decrypt password/passphrase for server with id '" + serverId + "', using auth token as is: " + e.getMessage();
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(msg, (Throwable)e);
            } else {
                this.logger.warn(msg);
            }
            return str;
        }
    }

    @Override
    public ScmProvider getRepositoryProvider(ScmRepository repository) throws NoSuchScmProviderException {
        return this.scmManager.get().getProviderByRepository(repository);
    }
}

