/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.transform.jdom;

import java.util.Iterator;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;

public final class JDomUtils {
    private JDomUtils() {
    }

    public static void rewriteValue(Element element, String value) {
        Text text = null;
        if (element.getContent() != null) {
            Iterator it = element.getContent().iterator();
            while (it.hasNext()) {
                Object content = it.next();
                if (!(content instanceof Text) || ((Text)content).getTextTrim().length() <= 0) continue;
                text = (Text)content;
                while (it.hasNext() && (content = it.next()) instanceof Text) {
                    text.append((Text)content);
                    it.remove();
                }
                break block0;
            }
        }
        if (text == null) {
            element.addContent(value);
        } else {
            String chars = text.getText();
            String trimmed = text.getTextTrim();
            int idx = chars.indexOf(trimmed);
            String leadingWhitespace = chars.substring(0, idx);
            String trailingWhitespace = chars.substring(idx + trimmed.length());
            text.setText(leadingWhitespace + value + trailingWhitespace);
        }
    }

    public static Element rewriteElement(String name, String value, Element root, Namespace namespace) {
        Element tagElement = root.getChild(name, namespace);
        if (tagElement != null) {
            if (value != null) {
                JDomUtils.rewriteValue(tagElement, value);
            } else {
                int index = root.indexOf((Content)tagElement);
                root.removeContent(index);
                for (int i = index - 1; i >= 0 && root.getContent(i) instanceof Text; --i) {
                    root.removeContent(i);
                }
            }
        } else if (value != null) {
            Element element = new Element(name, namespace);
            element.setText(value);
            root.addContent("  ").addContent((Content)element).addContent("\n  ");
            tagElement = element;
        }
        return tagElement;
    }
}

